/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.LinkException;
import com.agenarisk.api.model.Link;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.interfaces.Storable;
import java.util.ArrayList;
import java.util.Objects;
import org.json.JSONObject;
import uk.co.agena.minerva.model.ConstantMessagePassingLink;
import uk.co.agena.minerva.model.ConstantStateMessagePassingLink;
import uk.co.agena.minerva.model.ConstantSummaryMessagePassingLink;
import uk.co.agena.minerva.model.MessagePassingLink;
import uk.co.agena.minerva.model.MessagePassingLinks;
import uk.co.agena.minerva.model.Model;
import uk.co.agena.minerva.model.ModelEvent;
import uk.co.agena.minerva.model.corebn.CoreBNException;
import uk.co.agena.minerva.model.extendedbn.ContinuousEN;
import uk.co.agena.minerva.model.extendedbn.DiscreteRealEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBNException;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.ExtendedNodeFunction;
import uk.co.agena.minerva.model.extendedbn.ExtendedState;
import uk.co.agena.minerva.model.extendedbn.LabelledEN;
import uk.co.agena.minerva.model.extendedbn.RankedEN;
import uk.co.agena.minerva.util.helpers.MathsHelper;
import uk.co.agena.minerva.util.model.MinervaRangeException;
import uk.co.agena.minerva.util.model.NameDescription;
import uk.co.agena.minerva.util.model.Variable;
import uk.co.agena.minerva.util.nptgenerator.Arithmetic;
import uk.co.agena.minerva.util.nptgenerator.Normal;

public class CrossNetworkLink
extends Link
implements Storable {
    private MessagePassingLink logicLink;
    private Type type = null;
    private String stateToPass = null;

    private CrossNetworkLink(Node fromNode, Node toNode, Type type, String stateToPass) {
        super(fromNode, toNode);
        this.type = type;
        this.stateToPass = stateToPass;
    }

    protected static CrossNetworkLink createCrossNetworkLink(Node fromNode, Node toNode, Type type, String stateToPass) throws LinkException {
        if (Objects.equals(fromNode.getNetwork(), toNode.getNetwork())) {
            throw new LinkException("Trying to link nodes in same network by a cross network link");
        }
        if (type == null) {
            throw new LinkException("Cross network link type not specified");
        }
        if (type.equals((Object)Type.State) && stateToPass == null) {
            throw new LinkException("State to pass not provided");
        }
        if (stateToPass != null && !type.equals((Object)Type.State)) {
            throw new LinkException("Link type `" + type.toString() + "` does not pass a state `" + stateToPass + "`");
        }
        CrossNetworkLink link = new CrossNetworkLink(fromNode, toNode, type, stateToPass);
        return link;
    }

    @Override
    protected void createLogicLink() throws LinkException {
        if (this.logicLink != null) {
            throw new LinkException("Link already created");
        }
        ExtendedBN ebn1 = this.getFromNode().getNetwork().getLogicNetwork();
        ExtendedNode en1 = this.getFromNode().getLogicNode();
        ExtendedBN ebn2 = this.getToNode().getNetwork().getLogicNetwork();
        ExtendedNode en2 = this.getToNode().getLogicNode();
        try {
            en2.setConnectableInputNode(true);
        }
        catch (ExtendedBNException ex) {
            throw new LinkException("Logic node " + this.getToNode().toStringExtra() + " already has parents", ex);
        }
        en1.setConnectableOutputNode(true);
        if (Type.Marginals.equals((Object)this.type)) {
            if (en2 instanceof LabelledEN || en2 instanceof DiscreteRealEN || en2 instanceof RankedEN) {
                ArrayList<ExtendedState> states = new ArrayList<ExtendedState>();
                for (ExtendedState es1 : en1.getExtendedStates()) {
                    ExtendedState es2 = new ExtendedState();
                    es2.setName(new NameDescription(es1.getName().getShortDescription(), es1.getName().getLongDescription()));
                    es2.setRange(es1.getRange());
                    es2.setNumericalValue(es1.getNumericalValue());
                    states.add(es2);
                }
                try {
                    en2.setExtendedStates(states);
                }
                catch (CoreBNException ex) {
                    throw new LinkException("Failed to create states for link pass " + this.toStringExtra(), ex);
                }
            } else {
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add("0");
                parameters.add("1000000");
                ExtendedNodeFunction enf = new ExtendedNodeFunction(Normal.displayName, parameters);
                ((ContinuousEN)en2).setExpression(enf);
            }
            this.logicLink = new MessagePassingLink(ebn2.getId(), ebn1.getId(), en2.getId(), en1.getId());
        } else if (Type.State.equals((Object)this.type)) {
            String stateName = this.stateToPass;
            int stateID = -1;
            for (ExtendedState es : en1.getExtendedStates()) {
                String esname = es.getName().getShortDescription();
                if (!esname.equalsIgnoreCase(stateName)) continue;
                stateID = es.getId();
            }
            if (stateID == -1) {
                throw new LinkException("Invalid state being passed in link " + this.toStringExtra());
            }
            String constantName = ConstantMessagePassingLink.createConstantName((ExtendedNode)en1);
            try {
                Variable variable = ebn2.addExpressionVariable(en2, constantName, new Double(0.0).doubleValue(), false);
                variable.setValueSet(true);
            }
            catch (ExtendedBNException ex) {
                throw new LinkException("Failed to create variable for link " + this.toStringExtra(), ex);
            }
            if (en2 instanceof ContinuousEN && !(en2 instanceof RankedEN)) {
                ArrayList<ExtendedState> extendedStates = new ArrayList<ExtendedState>();
                try {
                    ExtendedState estate = ExtendedState.createContinuousIntervalState((double)0.0, (double)1.0);
                    extendedStates.add(estate);
                    en2.setExtendedStates(extendedStates);
                }
                catch (CoreBNException | MinervaRangeException ex) {
                    throw new LinkException("Failed to create a state for input node in " + this.toStringExtra(), ex);
                }
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add(constantName);
                ExtendedNodeFunction enf = new ExtendedNodeFunction(Arithmetic.displayName, parameters);
                en2.setExpression(enf);
            } else {
                ArrayList<ExtendedState> states = new ArrayList<ExtendedState>();
                for (ExtendedState es : en1.getExtendedStates()) {
                    String esname = es.getName().getShortDescription();
                    states.add(ExtendedState.createLabelledState((String)esname, (String)esname));
                }
                try {
                    en2.setExtendedStates(states);
                }
                catch (CoreBNException ex) {
                    throw new LinkException("Failed to copy states to input node in " + this.toStringExtra(), ex);
                }
            }
            this.logicLink = new ConstantStateMessagePassingLink(stateID, constantName, ebn2.getId(), ebn1.getId(), en2.getId(), en1.getId());
        } else {
            MathsHelper.SummaryStatistic summaryStat;
            String constantName = ConstantMessagePassingLink.createConstantName((ExtendedNode)en1);
            try {
                Variable variable = ebn2.addExpressionVariable(en2, constantName, new Double(0.0).doubleValue(), false);
                variable.setValueSet(true);
            }
            catch (ExtendedBNException ex) {
                throw new IllegalArgumentException("Failed to create variable for link pass from `" + ebn1.getConnID() + "`.`" + en1.getConnNodeId() + "` to `" + ebn2.getConnID() + "`.`" + en2.getConnNodeId() + "`", ex);
            }
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(constantName);
            ExtendedNodeFunction enf = new ExtendedNodeFunction(Arithmetic.displayName, parameters);
            en2.setExpression(enf);
            if (null == this.type) {
                throw new LinkException("Invalid cross network link type: `" + (Object)((Object)this.type) + "`");
            }
            switch (this.type) {
                case Mean: {
                    summaryStat = MathsHelper.SummaryStatistic.MEAN;
                    break;
                }
                case Median: {
                    summaryStat = MathsHelper.SummaryStatistic.MEDIAN;
                    break;
                }
                case StandardDeviation: {
                    summaryStat = MathsHelper.SummaryStatistic.STANDARD_DEVIATION;
                    break;
                }
                case Variance: {
                    summaryStat = MathsHelper.SummaryStatistic.VARIANCE;
                    break;
                }
                case LowerPercentile: {
                    summaryStat = MathsHelper.SummaryStatistic.LOWER_PERCENTILE;
                    break;
                }
                case UpperPercentile: {
                    summaryStat = MathsHelper.SummaryStatistic.UPPER_PERCENTILE;
                    break;
                }
                default: {
                    throw new LinkException("Invalid cross network link type: `" + (Object)((Object)this.type) + "`");
                }
            }
            this.logicLink = new ConstantSummaryMessagePassingLink(summaryStat, constantName, ebn2.getId(), ebn1.getId(), en2.getId(), en1.getId());
        }
        Model model = this.getFromNode().getNetwork().getModel().getLogicModel();
        MessagePassingLinks mpls = new MessagePassingLinks();
        mpls.getLinks().add(this.logicLink);
        model.getMessagePassingLinks().add(mpls);
        model.fireModelChangedEvent(model, ModelEvent.MESSAGE_PASSING_LINKS_CHANGED, model.getMessagePassingLinks());
    }

    @Override
    protected void destroyLogicLink() {
        this.getFromNode().getNetwork().getModel().getLogicModel().removeMessageParseLinks(this.getFromNode().getLogicNode(), this.getToNode().getLogicNode());
        this.logicLink = null;
    }

    protected MessagePassingLink getLogicLink() {
        return this.logicLink;
    }

    public Type getType() {
        return this.type;
    }

    public String getStateToPass() {
        return this.stateToPass;
    }

    @Override
    public JSONObject toJson() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum Type {
        Marginals,
        Mean,
        Median,
        Variance,
        StandardDeviation,
        LowerPercentile,
        UpperPercentile,
        State;

    }

    public static enum Field {
        sourceNetwork,
        targetNetwork,
        sourceNode,
        targetNode,
        type,
        passState;

    }
}

