/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import com.agenarisk.api.exception.DataSetException;
import com.agenarisk.api.io.stub.SummaryStatistic;
import com.agenarisk.api.model.DataSet;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.ResultInterval;
import com.agenarisk.api.model.ResultValue;
import com.agenarisk.api.model.interfaces.Storable;
import com.agenarisk.api.util.Advisory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.co.agena.minerva.model.MarginalDataItem;
import uk.co.agena.minerva.model.MarginalDataItemList;
import uk.co.agena.minerva.model.MarginalDataStore;
import uk.co.agena.minerva.model.extendedbn.ContinuousIntervalEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBN;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.IntegerIntervalEN;
import uk.co.agena.minerva.model.extendedbn.NumericalEN;
import uk.co.agena.minerva.model.extendedbn.RankedEN;
import uk.co.agena.minerva.util.helpers.MathsHelper;
import uk.co.agena.minerva.util.model.DataPoint;
import uk.co.agena.minerva.util.model.IntervalDataPoint;
import uk.co.agena.minerva.util.model.MinervaRangeException;

public class CalculationResult
implements Storable {
    private final DataSet dataset;
    private final Node node;
    private final boolean continuous;
    private final LinkedHashMap<String, ResultValue> resultValues = new LinkedHashMap();
    private final MarginalDataItem logicResult;

    private CalculationResult(DataSet dataSet, Node node) throws DataSetException {
        MarginalDataItem mdi;
        this.dataset = dataSet;
        this.node = node;
        this.continuous = node.getLogicNode() instanceof IntegerIntervalEN || node.getLogicNode() instanceof ContinuousIntervalEN;
        int scenarioIndex = dataSet.getDataSetIndex();
        ExtendedBN ebn = node.getNetwork().getLogicNetwork();
        ExtendedNode en = node.getLogicNode();
        try {
            MarginalDataStore mds = dataSet.getModel().getLogicModel().getMarginalDataStore();
            MarginalDataItemList mdil = mds.getMarginalDataItemListForNode(ebn, en);
            mdi = mdil.getMarginalDataItemAtIndex(scenarioIndex);
            mdi.getDataset();
        }
        catch (Exception ex) {
            throw new DataSetException("No result available", ex);
        }
        this.logicResult = mdi;
        for (DataPoint dp : mdi.getDataset().getDataPoints()) {
            ResultValue rv;
            double value = dp.getValue();
            String label = dp.getLabel();
            if (dp instanceof IntervalDataPoint) {
                IntervalDataPoint idp = (IntervalDataPoint)dp;
                if (label.trim().isEmpty()) {
                    label = null;
                }
                rv = new ResultInterval(this, label, idp.getValue(), idp.getIntervalLowerBound(), idp.getIntervalUpperBound());
            } else {
                rv = new ResultValue(this, label, value);
            }
            this.resultValues.put(label, rv);
        }
    }

    protected static void loadCalculationResult(DataSet dataSet, JSONObject jsonResult) throws DataSetException {
        Node node;
        String networkId = jsonResult.getString(Field.network.toString());
        String nodeId = jsonResult.getString(Field.node.toString());
        try {
            node = dataSet.getModel().getNetwork(networkId).getNode(nodeId);
            node.getId();
        }
        catch (NullPointerException ex) {
            String message = "Not found node with ID `" + nodeId + "` in network with ID `" + networkId + "`";
            if (Advisory.getCurrentThreadGroup() != null) {
                Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage(message, ex));
                return;
            }
            throw new DataSetException(message, ex);
        }
        int scenarioIndex = dataSet.getDataSetIndex();
        ExtendedBN ebn = node.getNetwork().getLogicNetwork();
        ExtendedNode en = node.getLogicNode();
        MarginalDataStore mds = dataSet.getModel().getLogicModel().getMarginalDataStore();
        MarginalDataItemList mdil = mds.getMarginalDataItemListForNode(ebn, en);
        if (mdil == null) {
            mdil = new MarginalDataItemList(ebn, en);
            mds.getNodeMarginalListMap().put(en, mdil);
        }
        while (mdil.getMarginalDataItems().size() <= scenarioIndex) {
            mdil.getMarginalDataItems().add(null);
        }
        MarginalDataItem mdi = mdil.getMarginalDataItemAtIndex(scenarioIndex);
        if (mdi == null) {
            mdi = new MarginalDataItem(dataSet.getId());
            mdi.setCallSignToUpdateOn(scenarioIndex + "");
            mdi.setOnlyUpdateOnMatchedCallSign(true);
            mdil.getMarginalDataItems().set(scenarioIndex, mdi);
        }
        uk.co.agena.minerva.util.model.DataSet ds = mdi.getDataset();
        ds.clearDataPoints();
        JSONArray jsonValues = jsonResult.getJSONArray(ResultValue.Field.resultValues.toString());
        for (int i = 0; i < jsonValues.length(); ++i) {
            JSONObject jsonEntry = jsonValues.getJSONObject(i);
            String label = jsonEntry.getString(ResultValue.Field.label.toString());
            Double value = jsonEntry.getDouble(ResultValue.Field.value.toString());
            if (en instanceof NumericalEN && !(en instanceof RankedEN) && label.contains(" - ")) {
                String[] bounds = label.split(" - ");
                Double lowerBound = Double.valueOf(bounds[0]);
                Double upperBound = Double.valueOf(bounds[1]);
                try {
                    if (en instanceof IntegerIntervalEN) {
                        int ilb = lowerBound.intValue();
                        int iub = upperBound.intValue();
                        label = ilb + (ilb != iub ? " - " + iub : "");
                    }
                    IntervalDataPoint idp = new IntervalDataPoint(label, value.doubleValue(), -1, lowerBound.doubleValue(), upperBound.doubleValue());
                    ds.addDataPoint((DataPoint)idp);
                    continue;
                }
                catch (MinervaRangeException ex) {
                    throw new DataSetException("Invalid range " + label + "` in node " + node.toStringExtra(), ex);
                }
            }
            try {
                int esId = node.getLogicNode().getExtendedStateWithName(label).getId();
                DataPoint dp = new DataPoint(label, value.doubleValue(), esId);
                ds.addDataPoint(dp);
                continue;
            }
            catch (NullPointerException ex) {
                ds.clearDataPoints();
                String message = "Recalculation required: result data corrupted or missing for node " + node.toStringExtra();
                if (Advisory.getCurrentThreadGroup() != null) {
                    Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage(message, ex));
                    return;
                }
                throw new DataSetException(message, ex);
            }
        }
        if (jsonResult.has(SummaryStatistic.Field.summaryStatistics.toString())) {
            JSONObject jsonSS = jsonResult.getJSONObject(SummaryStatistic.Field.summaryStatistics.toString());
            double confidenceInterval = jsonSS.optDouble(SummaryStatistic.Field.confidenceInterval.toString(), mdi.getConfidenceInterval());
            double mean = jsonSS.optDouble(SummaryStatistic.Field.mean.toString(), mdi.getMeanValue());
            double median = jsonSS.optDouble(SummaryStatistic.Field.median.toString(), mdi.getMedianValue());
            double standardDeviation = jsonSS.optDouble(SummaryStatistic.Field.standardDeviation.toString(), mdi.getStandardDeviationValue());
            double variance = jsonSS.optDouble(SummaryStatistic.Field.variance.toString(), mdi.getVarianceValue());
            double entropy = jsonSS.optDouble(SummaryStatistic.Field.entropy.toString(), mdi.getEntropyValue());
            double percentile = jsonSS.optDouble(SummaryStatistic.Field.percentile.toString(), mdi.getPercentileValue());
            double lowerPercentile = jsonSS.optDouble(SummaryStatistic.Field.lowerPercentile.toString(), mdi.getLowerPercentile());
            double upperPercentile = jsonSS.optDouble(SummaryStatistic.Field.upperPercentile.toString(), mdi.getUpperPercentile());
            mdi.setConfidenceInterval(confidenceInterval);
            mdi.setMeanValue(mean);
            mdi.setMedianValue(median);
            mdi.setStandardDeviationValue(standardDeviation);
            mdi.setVarianceValue(variance);
            mdi.setEntropyValue(entropy);
            mdi.setPercentileValue(percentile);
            mdi.setLowerPercentile(lowerPercentile);
            mdi.setUpperPercentile(upperPercentile);
        }
    }

    protected static CalculationResult getCalculationResult(DataSet dataset, Node node) {
        try {
            return new CalculationResult(dataset, node);
        }
        catch (DataSetException dataSetException) {
            return null;
        }
    }

    public DataSet getDataSet() {
        return this.dataset;
    }

    public Node getNode() {
        return this.node;
    }

    public List<ResultValue> getResultValues() {
        return this.resultValues.values().stream().collect(Collectors.toList());
    }

    public ResultValue getResultValue(String label) {
        return this.resultValues.get(label);
    }

    public double getConfidenceInterval() {
        return this.logicResult.getConfidenceInterval();
    }

    public double getEntropy() {
        return this.logicResult.getEntropyValue();
    }

    public double getVariance() {
        return this.logicResult.getVarianceValue();
    }

    public double getStandardDeviation() {
        return this.logicResult.getStandardDeviationValue();
    }

    public double getMean() {
        return this.logicResult.getMeanValue();
    }

    public double getMedian() {
        return this.logicResult.getMedianValue();
    }

    public double getPercentile() {
        return this.logicResult.getPercentileValue();
    }

    public double getLowerPercentile() {
        return this.logicResult.getLowerPercentile();
    }

    public double getUpperPercentile() {
        return this.logicResult.getUpperPercentile();
    }

    public double getPercentile(double percentile) {
        try {
            return MathsHelper.percentile((double)percentile, (uk.co.agena.minerva.util.model.DataSet)this.logicResult.getDataset());
        }
        catch (Exception ex) {
            throw new AgenaRiskRuntimeException("Failed to retrieve percentile " + percentile, ex);
        }
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put(Field.node.toString(), (Object)this.node.getId());
        json.put(Field.network.toString(), (Object)this.node.getNetwork().getId());
        json.put(ResultValue.Field.resultValues.toString(), (Object)new JSONArray((Collection)this.resultValues.values().stream().map(rv -> rv.toJson()).collect(Collectors.toList())));
        if (this.continuous) {
            JSONObject ssJson = new JSONObject();
            ssJson.put(SummaryStatistic.Field.confidenceInterval.toString(), this.getConfidenceInterval());
            ssJson.put(SummaryStatistic.Field.entropy.toString(), this.getEntropy());
            ssJson.put(SummaryStatistic.Field.lowerPercentile.toString(), this.getLowerPercentile());
            ssJson.put(SummaryStatistic.Field.mean.toString(), this.getMean());
            ssJson.put(SummaryStatistic.Field.median.toString(), this.getMedian());
            ssJson.put(SummaryStatistic.Field.percentile.toString(), this.getPercentile());
            ssJson.put(SummaryStatistic.Field.standardDeviation.toString(), this.getStandardDeviation());
            ssJson.put(SummaryStatistic.Field.upperPercentile.toString(), this.getUpperPercentile());
            ssJson.put(SummaryStatistic.Field.variance.toString(), this.getVariance());
            json.put(SummaryStatistic.Field.summaryStatistics.toString(), (Object)ssJson);
        }
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public String toString(int indentFactor) {
        return this.toJson().toString(indentFactor);
    }

    public MarginalDataItem getLogicCalculationResult() {
        return this.logicResult;
    }

    public static enum Field {
        results,
        result,
        network,
        node;

    }
}

