/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.co.agena.minerva.util.Logger;

public class VersionApi {
    private static final int revision;
    private static final String versionText;

    private static String retrieveVersion() {
        String revString = VersionApi.class.getPackage().getImplementationVersion();
        if (revString == null) {
            Logger.logIfDebug((String)"Failed to read API version from manifest");
            try (InputStream is = VersionApi.class.getResourceAsStream("/api.properties");
                 BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                revString = br.readLine();
            }
            catch (IOException | NullPointerException ex) {
                Logger.logIfDebug((String)("Failed to read API version from desktop.properties: " + ex.getMessage()));
            }
        }
        return revString;
    }

    private static Integer retrieveRevision(String version) {
        Integer revParsed = null;
        if (version != null) {
            try {
                revParsed = Integer.parseInt(version);
            }
            catch (NumberFormatException ex) {
                Logger.logIfDebug((String)("Failed to parse API version string: " + ex.getMessage()));
            }
        }
        if (revParsed == null) {
            return 0;
        }
        return revParsed;
    }

    public static int getRevision() {
        return revision;
    }

    public static String getVersionText() {
        return versionText;
    }

    static {
        versionText = VersionApi.retrieveVersion();
        revision = VersionApi.retrieveRevision(versionText);
    }
}

