/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.tools;

import com.agenarisk.api.exception.AdapterException;
import com.agenarisk.api.exception.CalculationException;
import com.agenarisk.api.exception.InconsistentEvidenceException;
import com.agenarisk.api.exception.ModelException;
import com.agenarisk.api.exception.NodeException;
import com.agenarisk.api.model.CalculationResult;
import com.agenarisk.api.model.Model;
import com.agenarisk.api.model.Network;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.ResultValue;
import com.agenarisk.api.model.State;
import com.agenarisk.api.tools.SensitivityAnalyserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.agena.minerva.util.helpers.MathsHelper;
import uk.co.agena.minerva.util.model.DataPoint;
import uk.co.agena.minerva.util.model.DataSet;
import uk.co.agena.minerva.util.model.IntervalDataPoint;
import uk.co.agena.minerva.util.model.Range;

public class SensitivityAnalyser {
    private Model model;
    private Node targetNode;
    private final LinkedHashSet<Node> sensitivityNodes = new LinkedHashSet();
    private com.agenarisk.api.model.DataSet dataSet;
    private boolean sumsMean = false;
    private boolean sumsMedian = false;
    private boolean sumsVariance = false;
    private boolean sumsStDev = false;
    private boolean sumsLowerPercentile = false;
    private boolean sumsUpperPercentile = false;
    private double sumsLowerPercentileValue = 25.0;
    private double sumsUpperPercentileValue = 75.0;
    private double sensLowerPercentileValue = 0.0;
    private double sensUpperPercentileValue = 100.0;
    private Map<Node, CalculationResult> bufResultsOriginal = new HashMap<Node, CalculationResult>();
    private final Map<Node, LinkedHashMap<BufferedCalculationKey, Double>> bufSACalcs = new HashMap<Node, LinkedHashMap<BufferedCalculationKey, Double>>();
    private final Map<Node, LinkedHashMap<BufferedStatisticKey, Double>> bufSAStats = new HashMap<Node, LinkedHashMap<BufferedStatisticKey, Double>>();
    private final Map<Node, LinkedHashMap<BufferedStatisticKey, Double>> bufSAStatsLim = new HashMap<Node, LinkedHashMap<BufferedStatisticKey, Double>>();

    public SensitivityAnalyser(Model model, JSONObject jsonConfig) throws SensitivityAnalyserException {
        Network network;
        if (model == null) {
            throw new SensitivityAnalyserException("Model not provided");
        }
        try {
            model = Model.createModel(model.export(Model.ExportFlags.KEEP_OBSERVATIONS, Model.ExportFlags.KEEP_META));
        }
        catch (AdapterException | ModelException | JSONException ex) {
            throw new SensitivityAnalyserException("Initialization failed", ex);
        }
        try {
            model.factorize();
        }
        catch (Exception ex) {
            throw new SensitivityAnalyserException("Factorization failed", ex);
        }
        this.model = model;
        model.getSettings().fromJson(jsonConfig.optJSONObject("modelSettings"));
        JSONObject jsonReportSettings = jsonConfig.optJSONObject("reportSettings");
        if (jsonReportSettings != null) {
            this.sumsMean = jsonReportSettings.optBoolean("sumsMean", false);
            this.sumsMedian = jsonReportSettings.optBoolean("sumsMedian", false);
            this.sumsVariance = jsonReportSettings.optBoolean("sumsVariance", false);
            this.sumsStDev = jsonReportSettings.optBoolean("sumsStDev", false);
            this.sumsLowerPercentile = jsonReportSettings.optBoolean("sumsLowerPercentile", false);
            this.sumsUpperPercentile = jsonReportSettings.optBoolean("sumsUpperPercentile", false);
            this.sumsLowerPercentileValue = jsonReportSettings.optDouble("sumsLowerPercentileValue", 25.0);
            this.sumsUpperPercentileValue = jsonReportSettings.optDouble("sumsUpperPercentileValue", 75.0);
            this.sensLowerPercentileValue = jsonReportSettings.optDouble("sensLowerPercentileValue", 0.0);
            this.sensUpperPercentileValue = jsonReportSettings.optDouble("sensUpperPercentileValue", 100.0);
        }
        if (jsonConfig.has("dataSet")) {
            this.dataSet = model.getDataSet(jsonConfig.optString("dataSet", ""));
            if (this.dataSet == null) {
                throw new SensitivityAnalyserException("DataSet with id `" + jsonConfig.optString("dataSet", "") + "` not found");
            }
        } else {
            this.dataSet = model.getDataSetList().get(0);
        }
        model.getDataSetList().forEach(ds -> {
            if (!ds.equals(this.dataSet)) {
                this.model.removeDataSet((com.agenarisk.api.model.DataSet)ds);
            }
        });
        if (jsonConfig.has("network")) {
            network = model.getNetwork(jsonConfig.optString("network", ""));
            if (network == null) {
                throw new SensitivityAnalyserException("Network with id `" + jsonConfig.optString("network", "") + "` not found");
            }
        } else {
            network = model.getNetworkList().get(0);
        }
        this.targetNode = network.getNode(jsonConfig.optString("targetNode", ""));
        if (this.targetNode == null) {
            throw new SensitivityAnalyserException("Target node not specified or Node with ID `" + jsonConfig.optString("targetNode", "") + "`");
        }
        JSONArray sensitivityNodes = jsonConfig.optJSONArray("sensitivityNodes");
        if (sensitivityNodes != null) {
            try {
                sensitivityNodes.forEach(o -> {
                    String nodeId = String.valueOf(o);
                    Node sensNode = network.getNode(nodeId);
                    if (sensNode == null) {
                        throw new NodeException("Node with ID `" + nodeId + "` not found in Network " + network.toStringExtra());
                    }
                    this.sensitivityNodes.add(sensNode);
                });
            }
            catch (NodeException ex) {
                throw new SensitivityAnalyserException(ex.getMessage());
            }
        } else if ("*".equals(jsonConfig.optString("sensitivityNodes"))) {
            network.getNodes().values().stream().filter(node -> !node.equals(this.targetNode)).collect(Collectors.toCollection(() -> this.sensitivityNodes));
        }
        if (this.sensitivityNodes.isEmpty()) {
            throw new SensitivityAnalyserException("No sensitivity nodes specified");
        }
        if (this.sensitivityNodes.contains(this.targetNode)) {
            throw new SensitivityAnalyserException("Target node can not also be selected as sensitivity node");
        }
        try {
            model.getDataSetList().get(0).getCalculationResults();
        }
        catch (Exception ex) {
            try {
                model.calculate();
            }
            catch (CalculationException ex1) {
                throw new SensitivityAnalyserException("Failed to precalculate the model during initialization (1)", ex1);
            }
        }
        if (!model.isCalculated()) {
            try {
                model.calculate();
            }
            catch (CalculationException ex) {
                throw new SensitivityAnalyserException("Failed to precalculate the model during initialization (2)", ex);
            }
        }
        try {
            model.convertToStatic(this.dataSet);
        }
        catch (NodeException ex) {
            throw new SensitivityAnalyserException("Static conversion failed", ex);
        }
        this.analyse();
    }

    private void analyse() throws SensitivityAnalyserException {
        this.calculateCombinations();
        this.calculateStats();
    }

    public JSONObject getFullReport() {
        JSONObject jsonReport = new JSONObject();
        jsonReport.put("responseCurveGraphs", (Object)this.buildResponseCurveGraphs());
        jsonReport.put("tables", (Object)this.buildTables());
        jsonReport.put("tornadoGraphs", (Object)this.buildTornadoGraphs());
        jsonReport.put("sensitivityConfig", (Object)this.getConfig());
        return jsonReport;
    }

    public JSONArray buildTables() {
        JSONArray jsonTables = new JSONArray();
        for (Node sensNode : this.sensitivityNodes) {
            Double value;
            JSONArray jsonRow;
            Map bufferedValues;
            JSONObject jsonTable = new JSONObject();
            jsonTable.put("title", (Object)("p(" + this.targetNode.getName() + " | " + sensNode.getName() + ")"));
            jsonTable.put("headerRows", (Object)sensNode.getName());
            jsonTable.put("headerColumns", (Object)this.targetNode.getName());
            jsonTable.put("sensitivityNode", (Object)sensNode.getId());
            JSONArray jsonRows = new JSONArray();
            jsonTable.put("rows", (Object)jsonRows);
            List<State> sensStates = sensNode.getStates();
            JSONArray jsonHeaderRow = new JSONArray();
            jsonHeaderRow.put((Object)(sensNode.getName() + " State"));
            jsonTable.put("headerRow", (Object)jsonHeaderRow);
            if (this.targetNode.isNumericInterval()) {
                bufferedValues = this.bufSAStats.get(sensNode);
                ArrayList<BufferedStatisticKey.STAT> statsRequested = new ArrayList<BufferedStatisticKey.STAT>();
                if (this.sumsMean) {
                    statsRequested.add(BufferedStatisticKey.STAT.mean);
                }
                if (this.sumsMedian) {
                    statsRequested.add(BufferedStatisticKey.STAT.median);
                }
                if (this.sumsVariance) {
                    statsRequested.add(BufferedStatisticKey.STAT.variance);
                }
                if (this.sumsStDev) {
                    statsRequested.add(BufferedStatisticKey.STAT.standardDeviation);
                }
                if (this.sumsLowerPercentile) {
                    statsRequested.add(BufferedStatisticKey.STAT.lowerPercentile);
                }
                if (this.sumsUpperPercentile) {
                    statsRequested.add(BufferedStatisticKey.STAT.upperPercentile);
                }
                for (BufferedStatisticKey.STAT statRequested : statsRequested) {
                    jsonHeaderRow.put((Object)statRequested);
                }
                for (State sensState : sensStates) {
                    jsonRow = new JSONArray();
                    if (sensNode.isNumericInterval()) {
                        jsonRow.put(sensState.getLogicState().getNumericalValue());
                    } else {
                        jsonRow.put((Object)sensState.getLabel());
                    }
                    for (BufferedStatisticKey.STAT statRequested : statsRequested) {
                        value = (Double)bufferedValues.get(new BufferedStatisticKey(statRequested, sensState.getLabel()));
                        if (Double.isInfinite(value) || Double.isNaN(value)) {
                            jsonRow.put((Object)(value + ""));
                            continue;
                        }
                        jsonRow.put((Object)value);
                    }
                    jsonRows.put((Object)jsonRow);
                }
            } else {
                bufferedValues = this.bufSACalcs.get(sensNode);
                List<State> tarStates = this.targetNode.getStates();
                for (State tarState : tarStates) {
                    jsonHeaderRow.put((Object)tarState.getLabel());
                }
                for (State sensState : sensStates) {
                    jsonRow = new JSONArray();
                    if (sensNode.isNumericInterval()) {
                        jsonRow.put(sensState.getLogicState().getNumericalValue());
                    } else {
                        jsonRow.put((Object)sensState.getLabel());
                    }
                    for (State tarState : tarStates) {
                        value = (Double)bufferedValues.get(new BufferedCalculationKey(this.targetNode, tarState.getLabel(), sensState.getLabel()));
                        jsonRow.put((Object)value);
                    }
                    jsonRows.put((Object)jsonRow);
                }
            }
            jsonTables.put((Object)jsonTable);
        }
        return jsonTables;
    }

    public JSONArray buildTornadoGraphs() {
        JSONArray jsonGraphs = new JSONArray();
        CalculationResult targetOriginal = this.bufResultsOriginal.get(this.targetNode);
        if (this.targetNode.isNumericInterval()) {
            ArrayList<BufferedStatisticKey.STAT> statsToGraph = new ArrayList<BufferedStatisticKey.STAT>();
            ArrayList<Double> originalValues = new ArrayList<Double>();
            if (this.sumsMean) {
                statsToGraph.add(BufferedStatisticKey.STAT.mean);
                originalValues.add(targetOriginal.getMean());
            }
            if (this.sumsMedian) {
                statsToGraph.add(BufferedStatisticKey.STAT.median);
                originalValues.add(targetOriginal.getMedian());
            }
            if (this.sumsVariance) {
                statsToGraph.add(BufferedStatisticKey.STAT.variance);
                originalValues.add(targetOriginal.getVariance());
            }
            if (this.sumsStDev) {
                statsToGraph.add(BufferedStatisticKey.STAT.standardDeviation);
                originalValues.add(targetOriginal.getStandardDeviation());
            }
            if (this.sumsLowerPercentile) {
                statsToGraph.add(BufferedStatisticKey.STAT.lowerPercentile);
                originalValues.add(targetOriginal.getLowerPercentile());
            }
            if (this.sumsUpperPercentile) {
                statsToGraph.add(BufferedStatisticKey.STAT.upperPercentile);
                originalValues.add(targetOriginal.getUpperPercentile());
            }
            for (int i = 0; i < statsToGraph.size(); ++i) {
                JSONObject jsonGraph = new JSONObject();
                BufferedStatisticKey.STAT statToGraph = (BufferedStatisticKey.STAT)((Object)statsToGraph.get(i));
                jsonGraph.put("summaryStatistic", (Object)statToGraph.toString());
                jsonGraph.put("originalValue", originalValues.get(i));
                ArrayList<JSONObject> jsonBarsList = new ArrayList<JSONObject>();
                for (Node sensNode : this.sensitivityNodes) {
                    Map bufferedValues = this.bufSAStatsLim.get(sensNode);
                    List<State> sensStates = sensNode.getStates();
                    State stateMin = sensStates.get(0);
                    Double valueMin = (Double)bufferedValues.get(new BufferedStatisticKey(statToGraph, sensStates.get(0).getLabel()));
                    State stateMax = sensStates.get(sensStates.size() - 1);
                    Double valueMax = (Double)bufferedValues.get(new BufferedStatisticKey(statToGraph, sensStates.get(sensStates.size() - 1).getLabel()));
                    for (State state : sensStates) {
                        Double value = (Double)bufferedValues.get(new BufferedStatisticKey(statToGraph, state.getLabel()));
                        if (Double.isNaN(value)) continue;
                        if (value < valueMin) {
                            valueMin = value;
                            stateMin = state;
                        }
                        if (!(value > valueMax)) continue;
                        valueMax = value;
                        stateMax = state;
                    }
                    if (Double.isNaN(valueMax) || Double.isNaN(valueMin)) continue;
                    JSONObject jsonBar = new JSONObject();
                    jsonBar.put("diff", valueMax - valueMin);
                    jsonBar.put("sensitivityNode", (Object)sensNode.getId());
                    jsonBar.put("stateMin", (Object)stateMin.getLabel());
                    jsonBar.put("labelMin", (Object)("P(" + sensNode.getName() + " = " + stateMin.getLabel() + ")"));
                    jsonBar.put("valueMin", (Object)valueMin);
                    jsonBar.put("stateMax", (Object)stateMax.getLabel());
                    jsonBar.put("labelMax", (Object)("P(" + sensNode.getName() + " = " + stateMax.getLabel() + ")"));
                    jsonBar.put("valueMax", (Object)valueMax);
                    jsonBarsList.add(jsonBar);
                }
                jsonBarsList.sort((o1, o2) -> Double.compare(o2.optDouble("diff"), o1.optDouble("diff")));
                JSONArray graphBars = new JSONArray(jsonBarsList);
                jsonGraph.put("graphBars", (Object)graphBars);
                jsonGraphs.put((Object)jsonGraph);
            }
        } else {
            List<State> tarStates = this.targetNode.getStates();
            for (int tarStateIndex = 0; tarStateIndex < tarStates.size(); ++tarStateIndex) {
                JSONObject jsonGraph = new JSONObject();
                State tarState = tarStates.get(tarStateIndex);
                jsonGraph.put("graphTitle", (Object)("P(" + this.targetNode.getName() + " = " + tarState.getLabel() + ")"));
                jsonGraph.put("targetState", (Object)tarState.getLabel());
                jsonGraph.put("originalValue", this.bufResultsOriginal.get(this.targetNode).getResultValue(tarState.getLabel()).getValue());
                ArrayList<JSONObject> jsonBarsList = new ArrayList<JSONObject>();
                for (Node sensNode : this.sensitivityNodes) {
                    Map bufferedValues = this.bufSACalcs.get(sensNode);
                    List<State> sensStates = sensNode.getStates();
                    State stateMin = sensStates.get(0);
                    Double valueMin = (Double)bufferedValues.get(new BufferedCalculationKey(this.targetNode, tarState.getLabel(), sensStates.get(0).getLabel()));
                    State stateMax = sensStates.get(sensStates.size() - 1);
                    Double valueMax = (Double)bufferedValues.get(new BufferedCalculationKey(this.targetNode, tarState.getLabel(), sensStates.get(sensStates.size() - 1).getLabel()));
                    for (State state : sensStates) {
                        Double value = (Double)bufferedValues.get(new BufferedCalculationKey(this.targetNode, tarState.getLabel(), state.getLabel()));
                        if (value < valueMin) {
                            valueMin = value;
                            stateMin = state;
                        }
                        if (!(value > valueMax)) continue;
                        valueMax = value;
                        stateMax = state;
                    }
                    JSONObject jsonBar = new JSONObject();
                    jsonBar.put("diff", valueMax - valueMin);
                    jsonBar.put("node", (Object)sensNode.getId());
                    jsonBar.put("stateMin", (Object)stateMin.getLabel());
                    jsonBar.put("labelMin", (Object)("P(" + sensNode.getName() + " = " + stateMin.getLabel() + ")"));
                    jsonBar.put("valueMin", (Object)valueMin);
                    jsonBar.put("stateMax", (Object)stateMax.getLabel());
                    jsonBar.put("labelMax", (Object)("P(" + sensNode.getName() + " = " + stateMax.getLabel() + ")"));
                    jsonBar.put("valueMax", (Object)valueMax);
                    jsonBarsList.add(jsonBar);
                }
                jsonBarsList.sort((o1, o2) -> Double.compare(o2.optDouble("diff"), o1.optDouble("diff")));
                JSONArray graphBars = new JSONArray(jsonBarsList);
                jsonGraph.put("graphBars", (Object)graphBars);
                jsonGraphs.put((Object)jsonGraph);
            }
        }
        return jsonGraphs;
    }

    public JSONArray buildResponseCurveGraphs() {
        JSONArray jsonROCs = new JSONArray();
        ArrayList<BufferedStatisticKey.STAT> statsRequested = new ArrayList<BufferedStatisticKey.STAT>();
        if (this.sumsMean) {
            statsRequested.add(BufferedStatisticKey.STAT.mean);
        }
        if (this.sumsMedian) {
            statsRequested.add(BufferedStatisticKey.STAT.median);
        }
        if (this.sumsVariance) {
            statsRequested.add(BufferedStatisticKey.STAT.variance);
        }
        if (this.sumsStDev) {
            statsRequested.add(BufferedStatisticKey.STAT.standardDeviation);
        }
        if (this.sumsLowerPercentile) {
            statsRequested.add(BufferedStatisticKey.STAT.lowerPercentile);
        }
        if (this.sumsUpperPercentile) {
            statsRequested.add(BufferedStatisticKey.STAT.upperPercentile);
        }
        for (Node sensNode : this.sensitivityNodes) {
            for (BufferedStatisticKey.STAT statRequested : statsRequested) {
                JSONObject jsonGraph = new JSONObject();
                jsonROCs.put((Object)jsonGraph);
                jsonGraph.put("titleX", (Object)(sensNode.getName() + " States"));
                jsonGraph.put("titleY", (Object)(this.targetNode.getName() + " " + (Object)((Object)statRequested)));
                jsonGraph.put("title", (Object)("p(" + this.targetNode.getName() + " | " + sensNode.getName() + ")"));
                jsonGraph.put("sensitivityNode", (Object)sensNode.getId());
                JSONArray jsonPoints = new JSONArray();
                jsonGraph.put("points", (Object)jsonPoints);
                List<State> sensStates = sensNode.getStates();
                for (State sensState : sensStates) {
                    Object x;
                    Double value = this.bufSAStatsLim.get(sensNode).get(new BufferedStatisticKey(statRequested, sensState.getLabel()));
                    if (Double.isNaN(value)) continue;
                    JSONObject jsonPoint = new JSONObject();
                    jsonPoints.put((Object)jsonPoint);
                    if (sensNode.isNumericInterval()) {
                        boolean infP;
                        x = sensState.getLogicState().getNumericalValue();
                        boolean infN = sensState.getLogicState().getRange().getLowerBound() == Double.NEGATIVE_INFINITY;
                        boolean bl = infP = sensState.getLogicState().getRange().getUpperBound() == Double.POSITIVE_INFINITY;
                        if (infN && infP) {
                            x = "0";
                        } else if (infN) {
                            x = sensState.getLogicState().getRange().getUpperBound();
                        } else if (infP) {
                            x = sensState.getLogicState().getRange().getLowerBound();
                        }
                    } else {
                        x = sensState.getLabel();
                    }
                    double y = value;
                    jsonPoint.put("x", x);
                    jsonPoint.put("y", y);
                }
            }
        }
        return jsonROCs;
    }

    private void calculateCombinations() throws SensitivityAnalyserException {
        this.bufResultsOriginal = this.dataSet.getCalculationResults(this.targetNode.getNetwork());
        CalculationResult tarCalcOri = this.bufResultsOriginal.get(this.targetNode);
        ArrayList<ResultValue> tarResValOri = new ArrayList<ResultValue>(tarCalcOri.getResultValues());
        List<State> tarStates = this.targetNode.getStates();
        for (int indexTarResVal = 0; indexTarResVal < this.targetNode.getLogicNode().getExtendedStates().size(); ++indexTarResVal) {
            State tarState = tarStates.get(indexTarResVal);
            String tarObsVal = tarState.getLabel();
            if (this.targetNode.isNumericInterval()) {
                tarObsVal = "" + tarState.getLogicState().getNumericalValue();
            }
            this.dataSet.setObservation(this.targetNode, tarObsVal);
            try {
                this.model.calculate();
            }
            catch (InconsistentEvidenceException ex) {
                continue;
            }
            catch (CalculationException ex) {
                throw new SensitivityAnalyserException("Calculation failure", ex);
            }
            Map<Node, CalculationResult> resultsSubjective = this.dataSet.getCalculationResults(this.targetNode.getNetwork());
            ResultValue tvO = tarResValOri.get(indexTarResVal);
            CalculationResult tarCalcSub = resultsSubjective.get(this.targetNode);
            ArrayList<ResultValue> tarResValSub = new ArrayList<ResultValue>(tarCalcSub.getResultValues());
            ResultValue tvS = tarResValSub.get(indexTarResVal);
            if (tarResValSub.size() != this.targetNode.getLogicNode().getExtendedStates().size()) {
                throw new SensitivityAnalyserException("Calculation result size does not match for target node");
            }
            for (Node sensitivityNode : this.sensitivityNodes) {
                if (!this.bufSACalcs.containsKey(sensitivityNode)) {
                    this.bufSACalcs.put(sensitivityNode, new LinkedHashMap());
                }
                CalculationResult sensCalcOri = this.bufResultsOriginal.get(sensitivityNode);
                CalculationResult sensCalcSub = resultsSubjective.get(sensitivityNode);
                ArrayList<ResultValue> sensResValOri = new ArrayList<ResultValue>(sensCalcOri.getResultValues());
                ArrayList<ResultValue> sensResValSub = new ArrayList<ResultValue>(sensCalcSub.getResultValues());
                if (sensResValOri.size() != sensResValSub.size()) {
                    throw new SensitivityAnalyserException("Calculation result size does not match for node " + sensitivityNode.toStringExtra());
                }
                List<State> sensStates = sensitivityNode.getStates();
                for (int indexSensResVal = 0; indexSensResVal < sensResValOri.size(); ++indexSensResVal) {
                    State sensState = sensStates.get(indexSensResVal);
                    ResultValue rvO = sensResValOri.get(indexSensResVal);
                    ResultValue rvS = sensResValSub.get(indexSensResVal);
                    double value = rvS.getValue();
                    double reverse = value * tvO.getValue() / rvO.getValue();
                    this.bufSACalcs.get(sensitivityNode).put(new BufferedCalculationKey(sensitivityNode, sensState.getLabel(), tarState.getLabel()), value);
                    this.bufSACalcs.get(sensitivityNode).put(new BufferedCalculationKey(this.targetNode, tarState.getLabel(), sensState.getLabel()), reverse);
                }
            }
        }
        this.dataSet.clearObservation(this.targetNode);
    }

    private void calculateStats() throws SensitivityAnalyserException {
        List<State> tarStates = this.targetNode.getStates();
        for (Node sensitivityNode : this.sensitivityNodes) {
            DataSet tempA1ResultsOriginal = (DataSet)this.bufResultsOriginal.get(sensitivityNode).getLogicCalculationResult().getDataset().clone();
            if (sensitivityNode.isNumericInterval()) {
                try {
                    double actUpperP = MathsHelper.percentile((double)this.sensUpperPercentileValue, (DataSet)tempA1ResultsOriginal);
                    double actLowerP = MathsHelper.percentile((double)this.sensLowerPercentileValue, (DataSet)tempA1ResultsOriginal);
                    for (int i = 0; i < tempA1ResultsOriginal.size(); ++i) {
                        IntervalDataPoint dp = (IntervalDataPoint)tempA1ResultsOriginal.getDataPointAtOrderPosition(i);
                        if (!(dp.getIntervalUpperBound() < actLowerP) && !(dp.getIntervalLowerBound() > actUpperP)) continue;
                        dp.setValue(Double.NaN);
                    }
                }
                catch (Exception ex) {
                    throw new SensitivityAnalyserException("Failed to apply continuous node sensitivity percentiles", ex);
                }
            }
            if (!this.bufSAStats.containsKey(sensitivityNode)) {
                this.bufSAStats.put(sensitivityNode, new LinkedHashMap());
            }
            if (!this.bufSAStatsLim.containsKey(sensitivityNode)) {
                this.bufSAStatsLim.put(sensitivityNode, new LinkedHashMap());
            }
            List<State> sensStates = sensitivityNode.getStates();
            for (int indexSensState = 0; indexSensState < sensitivityNode.getLogicNode().getExtendedStates().size(); ++indexSensState) {
                State sensState = sensStates.get(indexSensState);
                double mean = 0.0;
                double median = 0.0;
                double variance = 0.0;
                double meanLim = 0.0;
                double medianLim = 0.0;
                double varianceLim = 0.0;
                double standardDeviation = 0.0;
                double upperPercentile = 0.0;
                double lowerPercentile = 0.0;
                double standardDeviationLim = 0.0;
                double upperPercentileLim = 0.0;
                double lowerPercentileLim = 0.0;
                double[] xVals = new double[tarStates.size()];
                double[] pXs = new double[tarStates.size()];
                double[] pXsWithZero = new double[tarStates.size()];
                Range[] xIntervals = new Range[tarStates.size()];
                boolean limAllNAN = Double.isNaN(this.bufResultsOriginal.get(sensitivityNode).getResultValues().get(indexSensState).getValue());
                DataSet targetA1DataSet = new DataSet();
                DataSet targetA1DataSetLim = new DataSet();
                for (int indexTarState = 0; indexTarState < tarStates.size(); ++indexTarState) {
                    State tarState = tarStates.get(indexTarState);
                    Range r = tarState.getLogicState().getRange();
                    try {
                        r = MathsHelper.scaleInfinities((Range)r);
                    }
                    catch (Exception ex) {
                        throw new SensitivityAnalyserException("Failed to scale infinities for state range " + r, ex);
                    }
                    xIntervals[indexTarState] = r;
                    if (this.bufResultsOriginal.get(this.targetNode).getResultValues().get(indexTarState).getValue() == 0.0) continue;
                    double dbl = this.bufSACalcs.get(sensitivityNode).get(new BufferedCalculationKey(this.targetNode, tarState.getLabel(), sensState.getLabel()));
                    double dblWithZero = Double.NaN;
                    try {
                        if (!Double.isNaN(tempA1ResultsOriginal.getDataPointAtOrderPosition(indexSensState).getValue())) {
                            dblWithZero = dbl;
                        }
                    }
                    catch (Exception ex) {
                        throw new SensitivityAnalyserException("Calculation results are unexpectedly missing", ex);
                    }
                    xVals[indexTarState] = tarState.getLogicState().getNumericalValue();
                    pXs[indexTarState] = dbl;
                    pXsWithZero[indexTarState] = dblWithZero;
                    IntervalDataPoint idp = new IntervalDataPoint();
                    idp.setValue(dbl);
                    idp.setIntervalLowerBound(r.getLowerBound());
                    idp.setIntervalUpperBound(r.getUpperBound());
                    targetA1DataSet.addDataPoint((DataPoint)idp);
                    IntervalDataPoint idpWithZero = new IntervalDataPoint();
                    idpWithZero.setValue(dblWithZero);
                    idpWithZero.setIntervalLowerBound(r.getLowerBound());
                    idpWithZero.setIntervalUpperBound(r.getUpperBound());
                    targetA1DataSetLim.addDataPoint((DataPoint)idpWithZero);
                }
                try {
                    mean = MathsHelper.mean((double[])pXs, (double[])xVals);
                    meanLim = limAllNAN ? Double.NaN : MathsHelper.mean((double[])pXsWithZero, (double[])xVals);
                    variance = MathsHelper.variance((DataSet)targetA1DataSet);
                    varianceLim = limAllNAN ? Double.NaN : MathsHelper.variance((DataSet)targetA1DataSetLim);
                    standardDeviation = Math.sqrt(variance);
                    standardDeviationLim = limAllNAN ? Double.NaN : Math.sqrt(varianceLim);
                }
                catch (Exception ex) {
                    throw new SensitivityAnalyserException("Failed to calculate SA summary statistics", ex);
                }
                if (Double.isNaN(mean) && Double.isNaN(variance)) {
                    median = Double.NaN;
                    upperPercentile = Double.NaN;
                    lowerPercentile = Double.NaN;
                    medianLim = Double.NaN;
                    upperPercentileLim = Double.NaN;
                    lowerPercentileLim = Double.NaN;
                } else {
                    try {
                        median = MathsHelper.percentile((double)50.0, (double[])pXs, (Range[])xIntervals);
                        upperPercentile = MathsHelper.percentile((double)this.sumsUpperPercentileValue, (double[])pXs, (Range[])xIntervals);
                        lowerPercentile = MathsHelper.percentile((double)this.sumsLowerPercentileValue, (double[])pXs, (Range[])xIntervals);
                        medianLim = limAllNAN ? Double.NaN : MathsHelper.percentile((double)50.0, (double[])pXsWithZero, (Range[])xIntervals);
                        upperPercentileLim = limAllNAN ? Double.NaN : MathsHelper.percentile((double)this.sumsUpperPercentileValue, (double[])pXsWithZero, (Range[])xIntervals);
                        lowerPercentileLim = limAllNAN ? Double.NaN : MathsHelper.percentile((double)this.sumsLowerPercentileValue, (double[])pXsWithZero, (Range[])xIntervals);
                    }
                    catch (Exception ex) {
                        throw new SensitivityAnalyserException("Failed to calculate Sensitivity summary statistics", ex);
                    }
                }
                this.bufSAStats.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.mean, sensState.getLabel()), mean);
                this.bufSAStats.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.median, sensState.getLabel()), median);
                this.bufSAStats.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.variance, sensState.getLabel()), variance);
                this.bufSAStats.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.standardDeviation, sensState.getLabel()), standardDeviation);
                this.bufSAStats.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.upperPercentile, sensState.getLabel()), upperPercentile);
                this.bufSAStats.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.lowerPercentile, sensState.getLabel()), lowerPercentile);
                this.bufSAStatsLim.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.mean, sensState.getLabel()), meanLim);
                this.bufSAStatsLim.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.median, sensState.getLabel()), medianLim);
                this.bufSAStatsLim.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.variance, sensState.getLabel()), varianceLim);
                this.bufSAStatsLim.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.standardDeviation, sensState.getLabel()), standardDeviationLim);
                this.bufSAStatsLim.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.upperPercentile, sensState.getLabel()), upperPercentileLim);
                this.bufSAStatsLim.get(sensitivityNode).put(new BufferedStatisticKey(BufferedStatisticKey.STAT.lowerPercentile, sensState.getLabel()), lowerPercentileLim);
            }
        }
    }

    public JSONObject getConfig() {
        JSONObject jsonConfig = new JSONObject();
        jsonConfig.put("targetNode", (Object)this.targetNode.getId());
        jsonConfig.put("network", (Object)this.targetNode.getNetwork().getId());
        jsonConfig.put("dataSet", (Object)this.dataSet.getId());
        JSONArray sensitivityNodes = new JSONArray();
        jsonConfig.put("sensitivityNodes", (Object)sensitivityNodes);
        this.sensitivityNodes.forEach(node -> sensitivityNodes.put((Object)node.getId()));
        JSONObject jsonReportSettings = new JSONObject();
        jsonConfig.put("reportSettings", (Object)jsonReportSettings);
        if (this.sumsMean) {
            jsonReportSettings.put("sumsMean", true);
        }
        if (this.sumsMedian) {
            jsonReportSettings.put("sumsMedian", true);
        }
        if (this.sumsVariance) {
            jsonReportSettings.put("sumsVariance", true);
        }
        if (this.sumsStDev) {
            jsonReportSettings.put("sumsStDev", true);
        }
        if (this.sumsLowerPercentile) {
            jsonReportSettings.put("sumsLowerPercentile", true);
        }
        if (this.sumsUpperPercentile) {
            jsonReportSettings.put("sumsUpperPercentile", true);
        }
        jsonReportSettings.put("sumsLowerPercentileValue", this.sumsLowerPercentileValue);
        jsonReportSettings.put("sumsUpperPercentileValue", this.sumsUpperPercentileValue);
        jsonReportSettings.put("sensLowerPercentileValue", this.sensLowerPercentileValue);
        jsonReportSettings.put("sensUpperPercentileValue", this.sensUpperPercentileValue);
        return jsonConfig;
    }

    private static class BufferedStatisticKey {
        private final STAT stat;
        private final String calcState;

        public BufferedStatisticKey(STAT stat, String calcState) {
            this.stat = stat;
            this.calcState = calcState;
        }

        public STAT getStat() {
            return this.stat;
        }

        public String getCalcState() {
            return this.calcState;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + Objects.hashCode((Object)this.stat);
            hash = 29 * hash + Objects.hashCode(this.calcState);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BufferedStatisticKey other = (BufferedStatisticKey)obj;
            if (!Objects.equals(this.calcState, other.calcState)) {
                return false;
            }
            return this.stat == other.stat;
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            json.put("summaryStatistic", (Object)this.stat);
            json.put("calcState", (Object)this.calcState);
            return json;
        }

        public String toString() {
            return this.toJson().toString();
        }

        static enum STAT {
            mean,
            median,
            variance,
            standardDeviation,
            upperPercentile,
            lowerPercentile;

        }
    }

    private class BufferedCalculationKey {
        final Node node;
        final String nodeState;
        final String calcState;

        public BufferedCalculationKey(Node node, String nodeState, String calcState) {
            this.node = node;
            this.nodeState = nodeState;
            this.calcState = calcState;
        }

        public Node getNode() {
            return this.node;
        }

        public String getNodeState() {
            return this.nodeState;
        }

        public String getCalcState() {
            return this.calcState;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + Objects.hashCode(this.node);
            hash = 67 * hash + Objects.hashCode(this.nodeState);
            hash = 67 * hash + Objects.hashCode(this.calcState);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BufferedCalculationKey other = (BufferedCalculationKey)obj;
            if (!Objects.equals(this.node, other.node)) {
                return false;
            }
            if (!Objects.equals(this.nodeState, other.nodeState)) {
                return false;
            }
            return Objects.equals(this.calcState, other.calcState);
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            json.put("node", (Object)this.node.toStringExtra());
            json.put("nodeState", (Object)this.nodeState);
            json.put("calcState", (Object)this.calcState);
            return json;
        }

        public String toString() {
            return this.toJson().toString();
        }
    }
}

