/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.model.CalculationResult;
import com.agenarisk.api.model.ResultValue;

public class ResultInterval
extends ResultValue {
    private final double lowerBound;
    private final double upperBound;

    protected ResultInterval(CalculationResult calculationResult, String label, double value, double lowerBound, double upperBound) {
        super(calculationResult, label == null ? ResultInterval.computeLabel(lowerBound, upperBound) : label, value);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    private static String computeLabel(double lowerBound, double upperBound) {
        double min = Math.min(lowerBound, upperBound);
        double max = Math.max(lowerBound, upperBound);
        return min + " - " + max;
    }
}

