/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.NodeException;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.NodeConfiguration;
import com.agenarisk.api.model.State;
import com.agenarisk.api.util.JSONUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NodeTemplate {
    private static final JSONObject TEMPLATE = JSONUtils.toJSONObject(new Object[][]{{Node.Field.id, "ID"}, {Node.Field.name, "NAME"}, {NodeConfiguration.Field.configuration, JSONUtils.toJSONObject(new Object[][]{{NodeConfiguration.Field.type, "NODE_TYPE"}, {State.Field.states, new JSONArray()}, {NodeConfiguration.Table.table, JSONUtils.toJSONObject(new Object[][]{{NodeConfiguration.Table.type, "TABLE_TYPE"}, {NodeConfiguration.Table.probabilities, new JSONArray()}})}})}});
    private JSONObject json;

    private NodeTemplate(Node.Type type) {
        try {
            this.json = new JSONObject(TEMPLATE.toString());
            this.setNodeType(type);
            switch (type) {
                case Boolean: {
                    this.setStates(new String[]{"False", "True"});
                    break;
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static NodeTemplate createTemplate(Node.Type type) {
        return new NodeTemplate(type);
    }

    public JSONObject getJSON() {
        return this.json;
    }

    public NodeTemplate setId(String id) throws JSONException {
        this.json.put(Node.Field.id.toString(), (Object)id);
        return this;
    }

    public NodeTemplate setName(String name) throws JSONException {
        this.json.put(Node.Field.name.toString(), (Object)name);
        return this;
    }

    public NodeTemplate setNodeType(Node.Type nodeType) throws JSONException {
        this.json.getJSONObject(NodeConfiguration.Field.configuration.toString()).put(NodeConfiguration.Field.type.toString(), (Object)nodeType);
        return this;
    }

    public NodeTemplate setStates(List<String> states) throws JSONException {
        this.json.getJSONObject(NodeConfiguration.Field.configuration.toString()).put(State.Field.states.toString(), (Object)new JSONArray(states));
        return this;
    }

    public NodeTemplate setStates(String[] states) throws JSONException {
        this.setStates(Arrays.asList(states));
        return this;
    }

    public NodeTemplate setTableType(NodeConfiguration.TableType tableType) throws JSONException {
        this.json.getJSONObject(NodeConfiguration.Field.configuration.toString()).getJSONObject(NodeConfiguration.Table.table.toString()).put(NodeConfiguration.Table.type.toString(), (Object)tableType);
        return this;
    }

    public NodeTemplate setNPTRows(Double[][] rows) throws JSONException {
        this.json.getJSONObject(NodeConfiguration.Field.configuration.toString()).getJSONObject(NodeConfiguration.Table.table.toString()).put(NodeConfiguration.Table.probabilities.toString(), (Object)new JSONArray((Collection)Arrays.asList(rows).stream().map(darray -> new JSONArray(Arrays.asList(darray))).collect(Collectors.toList())));
        return this;
    }

    public NodeTemplate setNPTColumns(double[][] columns) {
        return this;
    }

    public static JSONObject generateTableFromRows(Double[][] rows) throws NodeException {
        JSONObject jsonTable;
        NodeTemplate nt = NodeTemplate.createTemplate(Node.Type.Boolean);
        try {
            nt.setNPTRows(rows);
            nt.setTableType(NodeConfiguration.TableType.Manual);
            jsonTable = nt.getJSON().getJSONObject(NodeConfiguration.Field.configuration.toString()).getJSONObject(NodeConfiguration.Table.table.toString());
        }
        catch (JSONException ex) {
            throw new NodeException("Failed to generate a table JSON", ex);
        }
        return jsonTable;
    }
}

