/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import com.agenarisk.api.exception.LinkException;
import com.agenarisk.api.exception.NetworkException;
import com.agenarisk.api.exception.NodeException;
import com.agenarisk.api.io.JSONAdapter;
import com.agenarisk.api.io.stub.Graphics;
import com.agenarisk.api.io.stub.Meta;
import com.agenarisk.api.io.stub.NodeGraphics;
import com.agenarisk.api.model.CrossNetworkLink;
import com.agenarisk.api.model.DataSet;
import com.agenarisk.api.model.Link;
import com.agenarisk.api.model.Model;
import com.agenarisk.api.model.Network;
import com.agenarisk.api.model.NodeConfiguration;
import com.agenarisk.api.model.State;
import com.agenarisk.api.model.VariableObservation;
import com.agenarisk.api.model.field.Id;
import com.agenarisk.api.model.interfaces.Identifiable;
import com.agenarisk.api.model.interfaces.Named;
import com.agenarisk.api.model.interfaces.Networked;
import com.agenarisk.api.model.interfaces.Storable;
import com.agenarisk.api.util.Advisory;
import com.agenarisk.api.util.JSONUtils;
import com.singularsys.jep.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.agena.minerva.model.corebn.CoreBNNodeNotFoundException;
import uk.co.agena.minerva.model.extendedbn.ContinuousEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBNException;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.ExtendedNodeFunction;
import uk.co.agena.minerva.model.extendedbn.ExtendedStateException;
import uk.co.agena.minerva.model.extendedbn.ExtendedStateNumberingException;
import uk.co.agena.minerva.model.extendedbn.NumericalEN;
import uk.co.agena.minerva.model.extendedbn.RankedEN;
import uk.co.agena.minerva.util.Logger;
import uk.co.agena.minerva.util.helpers.MathsHelper;
import uk.co.agena.minerva.util.model.DataPoint;
import uk.co.agena.minerva.util.model.IntervalDataPoint;
import uk.co.agena.minerva.util.model.MinervaRangeException;
import uk.co.agena.minerva.util.model.MinervaVariableException;
import uk.co.agena.minerva.util.model.NameDescription;
import uk.co.agena.minerva.util.model.Range;
import uk.co.agena.minerva.util.model.Variable;
import uk.co.agena.minerva.util.model.VariableList;
import uk.co.agena.minerva.util.nptgenerator.ExpressionParser;

public class Node
implements Networked<Node>,
Comparable<Node>,
Identifiable<NodeException>,
Storable,
Named {
    private final Network network;
    private final Set<Link> linksIn = Collections.synchronizedSet(new LinkedHashSet());
    private final Set<Link> linksOut = Collections.synchronizedSet(new LinkedHashSet());
    private ExtendedNode logicNode;
    private JSONObject jsonMeta;
    private JSONObject jsonGraphics;

    private Node(Network network, String id, String name, Type type) {
        ExtendedNode en;
        String nodeClassName = NodeConfiguration.resolveNodeClassName(type);
        try {
            en = network.getLogicNetwork().createNewExtendedNode(nodeClassName, new NameDescription(name, ""));
            network.getLogicNetwork().updateConnNodeId(en, id);
        }
        catch (CoreBNNodeNotFoundException | ExtendedBNException ex) {
            throw new AgenaRiskRuntimeException("Failed to create a node for ID `" + id + "`", ex);
        }
        this.network = network;
        this.logicNode = en;
        this.createDefaultStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Link> getLinksIn() {
        ArrayList<Link> list;
        Set<Link> set = this.linksIn;
        synchronized (set) {
            list = new ArrayList<Link>(this.linksIn);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Link> getLinksOut() {
        ArrayList<Link> list;
        Set<Link> set = this.linksOut;
        synchronized (set) {
            list = new ArrayList<Link>(this.linksOut);
        }
        return list;
    }

    @Override
    public synchronized Set<Node> getParents() {
        return this.getLinksIn().stream().map(link -> link.getFromNode()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public synchronized Set<Node> getChildren() {
        return this.getLinksOut().stream().map(link -> link.getToNode()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Deprecated
    protected boolean addLink(Link link) {
        if (link.getFromNode().equals(this)) {
            this.linksOut.add(link);
            return true;
        }
        if (link.getToNode().equals(this)) {
            this.linksIn.add(link);
            return true;
        }
        return false;
    }

    @Deprecated
    protected boolean removeLink(Link link) {
        if (link.getFromNode().equals(this)) {
            this.linksOut.remove(link);
            return true;
        }
        if (link.getToNode().equals(this)) {
            this.linksIn.remove(link);
            return true;
        }
        return false;
    }

    public synchronized Link linkTo(Node child) throws LinkException {
        return Node.linkNodes(this, child);
    }

    public synchronized Link linkFrom(Node parent) throws LinkException {
        return Node.linkNodes(parent, this);
    }

    public static boolean unlinkNodes(Node node1, Node node2) {
        List<Link> links = node1.getLinksIn();
        links.addAll(node1.getLinksOut());
        Link link = null;
        for (Link l : links) {
            if ((!l.getFromNode().equals(node1) || !l.getToNode().equals(node2)) && (!l.getFromNode().equals(node2) || !l.getToNode().equals(node1))) continue;
            link = l;
        }
        if (link == null) {
            return false;
        }
        node1.removeLink(link);
        node2.removeLink(link);
        link.destroyLogicLink();
        return true;
    }

    public static void linkNodes(Model model, JSONArray jsonLinks) throws JSONException, LinkException, NodeException {
        if (jsonLinks == null) {
            return;
        }
        for (int i = 0; i < jsonLinks.length(); ++i) {
            Node targetNode;
            Node sourceNode;
            JSONObject jsonLink = jsonLinks.getJSONObject(i);
            String net1Id = jsonLink.getString(CrossNetworkLink.Field.sourceNetwork.toString());
            String node1Id = jsonLink.getString(CrossNetworkLink.Field.sourceNode.toString());
            String net2Id = jsonLink.getString(CrossNetworkLink.Field.targetNetwork.toString());
            String node2Id = jsonLink.getString(CrossNetworkLink.Field.targetNode.toString());
            try {
                sourceNode = model.getNetwork(net1Id).getNode(node1Id);
                sourceNode.getId();
                targetNode = model.getNetwork(net2Id).getNode(node2Id);
                targetNode.getId();
            }
            catch (NullPointerException ex) {
                throw new LinkException("Network or node not found", ex);
            }
            CrossNetworkLink.Type linkType = CrossNetworkLink.Type.Marginals;
            try {
                String linkTypeString = jsonLink.getString(CrossNetworkLink.Field.type.toString());
                try {
                    linkType = CrossNetworkLink.Type.valueOf(linkTypeString);
                }
                catch (IllegalArgumentException ex) {
                    throw new LinkException("Invalid link type `" + linkTypeString + "`", ex);
                }
            }
            catch (JSONException ex) {
                Logger.logIfDebug((String)"No cross network link type provided, defaulting to type = Marginals");
            }
            String stateId = jsonLink.optString(CrossNetworkLink.Field.passState.toString(), null);
            try {
                Node.linkNodes(sourceNode, targetNode, linkType, stateId);
                continue;
            }
            catch (LinkException ex) {
                throw new NodeException("Failed to create a link between nodes " + sourceNode + " and " + targetNode, ex);
            }
        }
    }

    public static Link linkNodes(Node fromNode, Node toNode) throws LinkException {
        return Node.linkNodes(fromNode, toNode, null, null);
    }

    public static Link linkNodes(Node fromNode, Node toNode, CrossNetworkLink.Type type) throws LinkException {
        return Node.linkNodes(fromNode, toNode, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Link linkNodes(Node fromNode, Node toNode, CrossNetworkLink.Type type, String stateToPass) throws LinkException {
        Class<Network> clazz = Network.class;
        synchronized (Network.class) {
            Link link;
            boolean crossNetworkLink;
            if (fromNode.getChildren().contains(toNode)) {
                throw new LinkException("Link already exists");
            }
            if (Objects.equals(fromNode, toNode)) {
                throw new LinkException("Trying to link node to itself");
            }
            boolean bl = crossNetworkLink = !Objects.equals(fromNode.getNetwork(), toNode.getNetwork());
            if (toNode.isConnectedInput()) {
                throw new LinkException("Node " + fromNode.toStringExtra() + " already has an incoming cross network link");
            }
            if (crossNetworkLink) {
                if (!toNode.getLinksIn().isEmpty()) {
                    throw new LinkException("Can't add a cross network link to " + toNode.toStringExtra() + " because it already has parents");
                }
                if (toNode.getLogicNode().isConnectableOutputNode() && !toNode.getLinksOut().isEmpty()) {
                    throw new LinkException("Node " + toNode.toStringExtra() + " already appears to be configured for cross network outgoing link");
                }
                if (fromNode.getLogicNode().isConnectableInputNode() && !toNode.getLinksIn().isEmpty()) {
                    throw new LinkException("Node " + fromNode.toStringExtra() + " already appears to be configured for cross network incoming link");
                }
                if (!(Objects.equals((Object)fromNode.getType(), (Object)toNode.getType()) && Objects.equals(fromNode.isSimulated(), toNode.isSimulated()) || !fromNode.isNumericInterval() && !Type.DiscreteReal.equals((Object)fromNode.getType()) && toNode.isSimulated() || Objects.equals((Object)fromNode.getType(), (Object)toNode.getType()) && fromNode.isSimulated())) {
                    throw new LinkException("Cross network link not allowed between nodes (" + fromNode + " is " + (Object)((Object)fromNode.getType()) + ", " + toNode + " is " + (Object)((Object)toNode.getType()) + "), see documentation");
                }
                if (!fromNode.isSimulated() && !toNode.isSimulated() && fromNode.getLogicNode().getExtendedStates().size() != toNode.getLogicNode().getExtendedStates().size()) {
                    throw new LinkException("Cross network link can only be created between nodes with the same number of states");
                }
                link = CrossNetworkLink.createCrossNetworkLink(fromNode, toNode, type, stateToPass);
            } else {
                if (fromNode.getChildren().contains(toNode)) {
                    throw new LinkException("A link between " + fromNode.toStringExtra() + " and " + toNode.toStringExtra() + " already exists");
                }
                link = Link.createLink(fromNode, toNode);
            }
            fromNode.addLink(link);
            if (type == null) {
                if (fromNode.hasDescendant(fromNode)) {
                    fromNode.removeLink(link);
                    throw new LinkException("This link would create a loop in the network");
                }
            } else if (fromNode.getNetwork().hasDescendant(fromNode.getNetwork())) {
                fromNode.removeLink(link);
                throw new LinkException("This link would create a loop between networks");
            }
            toNode.addLink(link);
            try {
                link.createLogicLink();
            }
            catch (LinkException ex) {
                fromNode.removeLink(link);
                toNode.removeLink(link);
                throw ex;
            }
            return link;
        }
    }

    protected static Node createNode(Network network, String id, String name, Type type) {
        return new Node(network, id, name, type);
    }

    protected static Node createNode(Network network, JSONObject jsonNode) throws NodeException, JSONException {
        return Node.createNode(network, jsonNode, true);
    }

    protected static Node createNode(Network network, JSONObject jsonNode, boolean withTables) throws NodeException, JSONException {
        Node node;
        JSONObject jsonConfiguration;
        String id = jsonNode.getString(Field.id.toString());
        String name = jsonNode.optString(Field.name.toString());
        String description = jsonNode.optString(Field.description.toString());
        if (name.isEmpty()) {
            name = id;
        }
        if ((jsonConfiguration = jsonNode.optJSONObject(NodeConfiguration.Field.configuration.toString())) == null) {
            jsonConfiguration = new JSONObject();
        }
        String typeString = jsonConfiguration.optString(NodeConfiguration.Field.type.toString(), Type.Boolean.toString());
        Type type = Type.valueOf(typeString);
        try {
            node = network.createNode(id, name, type);
            node.setDescription(description);
        }
        catch (NetworkException ex) {
            throw new NodeException("Failed to add a node to network", ex);
        }
        ExtendedNode en = node.getLogicNode();
        boolean simulated = jsonConfiguration.optBoolean(NodeConfiguration.Field.simulated.toString(), false);
        if (simulated) {
            ContinuousEN cien = (ContinuousEN)en;
            NodeConfiguration.setDefaultIntervalStates(node);
            cien.setSimulationNode(true);
            if (jsonConfiguration.has(NodeConfiguration.Field.simulationConvergence.toString())) {
                cien.setEntropyConvergenceThreshold(jsonConfiguration.getDouble(NodeConfiguration.Field.simulationConvergence.toString()));
            }
        } else {
            node.setStates(jsonConfiguration.optJSONArray(State.Field.states.toString()));
        }
        if (jsonConfiguration.optBoolean(NodeConfiguration.Field.output.toString(), false)) {
            en.setConnectableOutputNode(true);
        }
        try {
            if (jsonConfiguration.optBoolean(NodeConfiguration.Field.input.toString(), false)) {
                en.setConnectableInputNode(true);
            }
        }
        catch (ExtendedBNException ex) {
            throw new NodeException("Can't mark node as input node", ex);
        }
        JSONArray jsonVariables = jsonConfiguration.optJSONArray(NodeConfiguration.Variables.variables.toString());
        if (jsonVariables != null) {
            for (int i = 0; i < jsonVariables.length(); ++i) {
                JSONObject jsonVariable = jsonVariables.getJSONObject(i);
                String variableName = jsonVariable.getString(NodeConfiguration.Variables.name.toString());
                Double variableValue = jsonVariable.getDouble(NodeConfiguration.Variables.value.toString());
                try {
                    Variable variable = en.addExpressionVariable(variableName, variableValue.doubleValue(), true);
                    continue;
                }
                catch (ExtendedBNException ex) {
                    throw new NodeException("Duplicate variable names detected", ex);
                }
            }
        }
        if (withTables) {
            JSONObject jsonTable = jsonConfiguration.optJSONObject(NodeConfiguration.Table.table.toString());
            node.setTable(jsonTable);
        }
        if (jsonNode.has(Meta.Field.meta.toString())) {
            node.jsonMeta = jsonNode.optJSONObject(Meta.Field.meta.toString());
        }
        if (jsonNode.has(Graphics.Field.graphics.toString())) {
            node.jsonGraphics = jsonNode.optJSONObject(Graphics.Field.graphics.toString());
        }
        try {
            node.loadMetaNotes();
        }
        catch (JSONException ex) {
            throw new NodeException("Failed loading model notes", ex);
        }
        try {
            boolean visible = jsonNode.optJSONObject(NodeGraphics.Field.graphics.toString()).optBoolean(NodeGraphics.Field.visible.toString());
            node.getLogicNode().setVisible(visible);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return node;
    }

    private void loadMetaNotes() throws JSONException {
        if (this.jsonMeta == null || this.jsonMeta.optJSONArray(Meta.Field.notes.toString()) == null) {
            return;
        }
        JSONArray jsonNotes = this.jsonMeta.optJSONArray(Meta.Field.notes.toString());
        for (int i = 0; i < jsonNotes.length(); ++i) {
            JSONObject jsonNote = jsonNotes.getJSONObject(i);
            String name = jsonNote.getString(Meta.Field.name.toString());
            String text = jsonNote.getString(Meta.Field.name.toString());
            this.getLogicNode().getNotes().addNote(name, text);
        }
        this.jsonMeta.remove(Meta.Field.notes.toString());
    }

    public void setTableColumns(double[][] columns) throws NodeException {
        for (int i = 0; i < columns.length; ++i) {
            for (int j = 0; j < columns[i].length; ++j) {
                if (columns[i].length == columns[0].length) continue;
                throw new NodeException("Table is not a square matrix");
            }
        }
        int sizeGiven = columns.length * columns[0].length;
        List<ExtendedNode> parentNodes = this.getParentExtendedNodes();
        AtomicInteger sizeExpected = new AtomicInteger(1);
        parentNodes.stream().forEachOrdered(n -> sizeExpected.set(sizeExpected.get() * n.getExtendedStates().size()));
        sizeExpected.set(sizeExpected.get() * this.getLogicNode().getExtendedStates().size());
        if (sizeExpected.get() != sizeGiven) {
            throw new NodeException("Table has a wrong number of cells (expecting: " + sizeExpected + ", given: " + sizeGiven + ")");
        }
        try {
            this.getLogicNode().setNPT(columns, parentNodes);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NodeException("Failed to set table, check parents", ex);
        }
        catch (ExtendedBNException ex) {
            throw new NodeException("Failed to set table", ex);
        }
    }

    public void setTableRows(double[][] rows) throws NodeException {
        double[][] columns = NodeConfiguration.transposeMatrix(rows);
        this.setTableColumns(columns);
    }

    public final boolean setTableUniform() {
        try {
            double[][] nptNew;
            float[][] nptCurrent = this.getLogicNode().getNPT();
            for (double[] row : nptNew = new double[nptCurrent[0].length][nptCurrent.length]) {
                Arrays.fill(row, 1.0);
            }
            MathsHelper.normaliseMatrix((double[][])nptNew);
            this.getLogicNode().setNPT(nptNew, this.getParentExtendedNodes());
        }
        catch (Exception ex) {
            Logger.printThrowableIfDebug((Throwable)ex);
            return false;
        }
        return true;
    }

    public void setTable(JSONObject jsonTable) throws NodeException {
        block24: {
            if (jsonTable == null || jsonTable.length() == 0) {
                return;
            }
            ArrayList<String> allowedTokens = new ArrayList<String>();
            List parentIDs = this.getParents().stream().filter(n -> n.getNetwork().equals(this.getNetwork())).map(node -> node.getId()).collect(Collectors.toList());
            List variableNames = this.getLogicNode().getExpressionVariables().getAllVariableNames();
            allowedTokens.addAll(parentIDs);
            allowedTokens.addAll(variableNames);
            try {
                String tableType = jsonTable.getString(NodeConfiguration.Table.type.toString());
                if (jsonTable.has(NodeConfiguration.Table.probabilities.toString())) {
                    try {
                        double[][] npt = NodeConfiguration.extractNPTColumns(jsonTable.getJSONArray(NodeConfiguration.Table.probabilities.toString()));
                        if (NodeConfiguration.Table.column.toString().equals(jsonTable.optString(NodeConfiguration.Table.pvalues.toString()))) {
                            npt = NodeConfiguration.transposeMatrix(npt);
                        }
                        List parentNodes = this.getParents().stream().filter(n -> n.getNetwork().equals(this.getNetwork())).map(node -> node.getLogicNode()).collect(Collectors.toList());
                        this.getLogicNode().setNPT(npt, parentNodes);
                    }
                    catch (ExtendedBNException ex) {
                        if (!tableType.equalsIgnoreCase(NodeConfiguration.TableType.Manual.toString())) {
                            this.getLogicNode().setNptReCalcRequired(true);
                            Advisory.addMessageIfLinked("Node " + this.toStringExtra() + " underlying table was corrupted and will need to be recalculated");
                        }
                        throw new NodeException("Failed to extract NPT", ex);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new NodeException("NPT may not be a square matrix", ex);
                    }
                }
                if (tableType.equalsIgnoreCase(NodeConfiguration.TableType.Manual.toString())) {
                    if (this.isSimulated() && !Advisory.addMessageIfLinked("Node " + this.toStringExtra() + " is simulated, but the table data had a Manual table type. We recommend to check the expressions in this node.")) {
                        throw new NodeException("Can't set a manual NPT for a simulated node");
                    }
                    break block24;
                }
                if (tableType.equalsIgnoreCase(NodeConfiguration.Table.expression.toString())) {
                    String expression = jsonTable.getJSONArray(NodeConfiguration.Table.expressions.toString()).getString(0);
                    if (Advisory.getCurrentThreadGroup() != null && expression.contains("?")) {
                        expression = expression.replace("?", "");
                        Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage("Functions for node " + this.toStringExtra() + " contained invalid characters and were cleaned. We recommend to check the expressions in this node."));
                    }
                    try {
                        this.setTableFunction(expression, allowedTokens);
                        break block24;
                    }
                    catch (NodeException ex) {
                        if (Advisory.getCurrentThreadGroup() != null) {
                            this.setTableFunction(expression, null, true);
                            Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage("Functions for node " + this.toStringExtra() + " contain invalid tokens. We recommend to check the expressions in this node.", ex));
                            break block24;
                        }
                        throw ex;
                    }
                }
                if (tableType.equalsIgnoreCase(NodeConfiguration.TableType.Partitioned.toString())) {
                    List<String> partitionParentIDs = JSONUtils.toList(jsonTable.getJSONArray(NodeConfiguration.Table.partitions.toString()), String.class);
                    ArrayList partitionParentNodes = new ArrayList();
                    partitionParentIDs.stream().forEachOrdered(parentID -> {
                        ExtendedNode parent = this.getNetwork().getLogicNetwork().getExtendedNodeWithUniqueIdentifier(parentID);
                        if (parent == null) {
                            throw new IllegalArgumentException("No such parent `" + parentID + "` found");
                        }
                        partitionParentNodes.add(parent);
                    });
                    this.getLogicNode().setPartitionedExpressionModelNodes(partitionParentNodes);
                    ArrayList<ExtendedNodeFunction> enfs = new ArrayList<ExtendedNodeFunction>();
                    List<String> expressions = JSONUtils.toList(jsonTable.getJSONArray(NodeConfiguration.Table.expressions.toString()), String.class);
                    for (String expression : expressions) {
                        ExtendedNodeFunction enf;
                        block25: {
                            if (Advisory.getCurrentThreadGroup() != null && expression.contains("?")) {
                                expression = expression.replace("?", "");
                                Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage("Functions for node " + this.toStringExtra() + " contained invalid characters and were cleaned. We recommend to check the expressions in this node."));
                            }
                            try {
                                try {
                                    enf = ExpressionParser.parseFunctionFromString((String)expression, allowedTokens, (boolean)false);
                                }
                                catch (ParseException ex) {
                                    if (Advisory.getCurrentThreadGroup() != null) {
                                        Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage("Functions for node " + this.toStringExtra() + " contain invalid tokens. We recommend to check the expressions in this node.", ex));
                                        enf = ExpressionParser.parseFunctionFromString((String)expression, null, (boolean)true);
                                        break block25;
                                    }
                                    throw ex;
                                }
                            }
                            catch (ParseException ex) {
                                throw new NodeException("Unable to parse node function `" + expression + "`", ex);
                            }
                        }
                        enfs.add(enf);
                    }
                    this.getLogicNode().setPartitionedExpressions(enfs);
                    break block24;
                }
                throw new NodeException("Invalid table type");
            }
            catch (JSONException ex) {
                throw new NodeException(JSONUtils.createMissingAttrMessage(ex), ex);
            }
        }
    }

    public void setTableFunction(String expression) throws NodeException {
        ArrayList<String> allowedTokens = new ArrayList<String>();
        List parentIDs = this.getParents().stream().filter(n -> n.getNetwork().equals(this.getNetwork())).map(node -> node.getId()).collect(Collectors.toList());
        List variableNames = this.getLogicNode().getExpressionVariables().getAllVariableNames();
        allowedTokens.addAll(parentIDs);
        allowedTokens.addAll(variableNames);
        this.setTableFunction(expression, allowedTokens);
    }

    public void setTableFunction(String expression, List<String> allowedTokens) throws NodeException {
        this.setTableFunction(expression, allowedTokens, false);
    }

    public void setTableFunction(String expression, List<String> allowedTokens, boolean relaxFunctionRequirements) throws NodeException {
        ExtendedNodeFunction enf;
        try {
            enf = ExpressionParser.parseFunctionFromString((String)expression, allowedTokens, (boolean)relaxFunctionRequirements);
            for (String fname : ExpressionParser.parsed_functions) {
                if (!fname.replaceAll(" ", "").equalsIgnoreCase(enf.getName())) continue;
                enf.setName(fname);
            }
        }
        catch (ParseException ex) {
            throw new NodeException("Unable to parse node function `" + expression + "`", ex);
        }
        this.getLogicNode().setExpression(enf);
    }

    public void setTableFunctions(String[] functions) throws NodeException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void partitionByParents(Node[] partitionParents) throws NodeException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setStates(String[] states) throws NodeException {
        if (this.isSimulated()) {
            throw new NodeException("Can't set states for a simulated node");
        }
        ExtendedNode en = this.getLogicNode();
        uk.co.agena.minerva.util.model.DataSet ds = new uk.co.agena.minerva.util.model.DataSet();
        for (int s = 0; s < states.length; ++s) {
            String stateName = states[s].trim();
            if (stateName.isEmpty()) {
                throw new NodeException("State name can't be an empty string");
            }
            if (en instanceof RankedEN) {
                ds.addLabelledDataPoint(stateName);
                continue;
            }
            if (en instanceof NumericalEN) {
                Range range;
                double lowerBound = Double.NEGATIVE_INFINITY;
                double upperBound = Double.POSITIVE_INFINITY;
                if (stateName.contains(" - ")) {
                    String[] parts = stateName.split(" - ");
                    lowerBound = Double.parseDouble(parts[0]);
                    upperBound = Double.parseDouble(parts[1]);
                } else {
                    upperBound = lowerBound = Double.parseDouble(stateName);
                }
                try {
                    range = new Range(lowerBound, upperBound);
                }
                catch (MinervaRangeException ex) {
                    throw new NodeException("Invalid state range in `" + stateName + "`", ex);
                }
                NameDescription nd = new NameDescription(stateName, stateName);
                IntervalDataPoint dp = new IntervalDataPoint();
                dp.setLabel(nd.getShortDescription());
                dp.setValue(range.midPoint());
                dp.setIntervalLowerBound(range.getLowerBound());
                dp.setIntervalUpperBound(range.getUpperBound());
                ds.addDataPoint((DataPoint)dp);
                continue;
            }
            ds.addLabelledDataPoint(stateName);
        }
        try {
            en.createExtendedStates(ds);
        }
        catch (ExtendedStateException | ExtendedStateNumberingException ex) {
            throw new NodeException("Failed to parse states", ex);
        }
    }

    public void setStates(JSONArray jsonStates) throws NodeException {
        if (jsonStates == null || jsonStates.length() == 0) {
            return;
        }
        String[] states = new String[jsonStates.length()];
        for (int s = 0; s < jsonStates.length(); ++s) {
            states[s] = jsonStates.optString(s, "");
        }
        this.setStates(states);
    }

    public boolean convertToSimulated() throws NodeException {
        boolean canSimulate;
        boolean bl = canSimulate = this.getLogicNode() instanceof ContinuousEN && !(this.getLogicNode() instanceof RankedEN);
        if (!canSimulate || this.isSimulated()) {
            return false;
        }
        NodeConfiguration.setDefaultIntervalStates(this);
        ContinuousEN cien = (ContinuousEN)this.getLogicNode();
        cien.setSimulationNode(true);
        return true;
    }

    public boolean convertToStatic(DataSet dataSet) throws NodeException {
        boolean canSimulate;
        boolean bl = canSimulate = this.getLogicNode() instanceof ContinuousEN && !(this.getLogicNode() instanceof RankedEN);
        if (!canSimulate || !this.isSimulated()) {
            return false;
        }
        ContinuousEN cien = (ContinuousEN)this.getLogicNode();
        try {
            uk.co.agena.minerva.util.model.DataSet ds = this.getNetwork().getModel().getLogicModel().getMarginalDataStore().getMarginalDataItemListForNode(this.getNetwork().getLogicNetwork(), this.getLogicNode()).getMarginalDataItemAtIndex(0).getDataset();
            ContinuousEN.ConvertToNonSimulation((ContinuousEN)cien, (uk.co.agena.minerva.util.model.DataSet)ds);
            for (VariableObservation vo : dataSet.getVariableObservations(this)) {
                String voName = vo.getVariableName();
                double varVal = vo.getVariableValue();
                VariableList logicVarList = this.getLogicNode().getExpressionVariables();
                Variable logicVar = logicVarList.getVariable(voName);
                logicVarList.updateVariable(logicVar, voName, varVal);
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException | ExtendedStateException | ExtendedStateNumberingException | MinervaVariableException ex) {
            throw new NodeException("Failed to convert results to static states for node " + this.toStringExtra() + " from DataSet " + dataSet.getId(), ex);
        }
        return true;
    }

    public boolean isSimulated() {
        if (this.getLogicNode() instanceof ContinuousEN && !(this.getLogicNode() instanceof RankedEN)) {
            return ((ContinuousEN)this.getLogicNode()).isSimulationNode();
        }
        return false;
    }

    public boolean isNumericInterval() {
        return Type.ContinuousInterval.equals((Object)this.getType()) || Type.IntegerInterval.equals((Object)this.getType());
    }

    public String toString() {
        return this.toJson().toString();
    }

    public String toStringExtra() {
        return "`" + this.getNetwork().getName() + " (" + this.getNetwork().getId() + ")`.`" + this.getName() + " (" + this.getId() + ")`";
    }

    public Network getNetwork() {
        return this.network;
    }

    public ExtendedNode getLogicNode() {
        return this.logicNode;
    }

    @Override
    public String getId() {
        return this.getLogicNode().getConnNodeId();
    }

    @Override
    public void setId(String newId) throws NodeException {
        String oldId = this.getId();
        String errorMessage = "Failed to change ID of Node from `" + oldId + "` to `" + newId + "`";
        try {
            this.getNetwork().changeContainedId(this, newId);
            this.getNetwork().getLogicNetwork().updateConnNodeId(this.getLogicNode(), newId);
        }
        catch (CoreBNNodeNotFoundException | ExtendedBNException ex) {
            try {
                this.getNetwork().changeContainedId(this, oldId);
            }
            catch (NetworkException ex2) {
                throw new NodeException(errorMessage, ex2);
            }
            throw new NodeException(errorMessage, ex);
        }
        catch (NetworkException ex) {
            throw new NodeException(errorMessage, ex);
        }
    }

    @Override
    public void setName(String name) {
        this.getLogicNode().getName().setShortDescription(name);
    }

    @Override
    public String getName() {
        return this.getLogicNode().getName().getShortDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getLogicNode().getName().setLongDescription(description);
    }

    @Override
    public String getDescription() {
        return this.getLogicNode().getName().getLongDescription();
    }

    @Override
    public int compareTo(Node o) {
        return new Id(this.getId()).compareTo(new Id(o.getId()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Node)) {
            return false;
        }
        return this.getLogicNode() == ((Node)obj).getLogicNode();
    }

    public int hashCode() {
        return System.identityHashCode(this.getLogicNode());
    }

    @Override
    public boolean unlink(Node linkedNode) {
        return Node.unlinkNodes(this, linkedNode);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = JSONAdapter.toJSONObject(this.logicNode);
        json.put(Graphics.Field.graphics.toString(), (Object)this.jsonGraphics);
        json.put(Meta.Field.meta.toString(), (Object)this.jsonMeta);
        return json;
    }

    public State getState(String label) {
        return State.getState(this, label);
    }

    public List<State> getStates() {
        return this.getLogicNode().getExtendedStates().stream().map(es -> State.getState(this, es.getName().getShortDescription())).collect(Collectors.toList());
    }

    public Type getType() {
        ExtendedNode en = this.getLogicNode();
        return NodeConfiguration.resolveNodeType(en);
    }

    protected void setLogicNode(ExtendedNode logicNode) {
        if (!new Id(this.getId()).equals(new Id(logicNode.getConnNodeId()))) {
            throw new AgenaRiskRuntimeException("Logic node id mismatch: " + this.getId() + "," + logicNode.getConnNodeId());
        }
        this.logicNode = logicNode;
    }

    private List<ExtendedNode> getParentExtendedNodes() {
        return this.getParents().stream().map(node -> node.getLogicNode()).collect(Collectors.toList());
    }

    private void createDefaultStates() {
        switch (this.getType()) {
            case ContinuousInterval: 
            case IntegerInterval: {
                this.setStates(new String[]{"-Infinity - -1", "-1 - 1", "1 - Infinity"});
                this.setTableRows(new double[][]{{1.0}, {1.0}, {1.0}});
            }
        }
    }

    public NodeConfiguration.TableType getTableType() {
        switch (this.logicNode.getFunctionMode()) {
            default: {
                return NodeConfiguration.TableType.Manual;
            }
            case 1: {
                return NodeConfiguration.TableType.Expression;
            }
            case 2: 
        }
        return NodeConfiguration.TableType.Partitioned;
    }

    public boolean isConnectedInput() {
        return this.getLinksIn().stream().anyMatch(link -> !Objects.equals(this.getNetwork(), link.getFromNode().getNetwork()));
    }

    public boolean isConnectedOutput() {
        return this.getLinksOut().stream().anyMatch(link -> !Objects.equals(this.getNetwork(), link.getToNode().getNetwork()));
    }

    public Set<Node> getAncestors() {
        HashSet<Node> set = new HashSet<Node>();
        this.getParents().stream().filter(n -> Objects.equals(this.getNetwork(), n.getNetwork())).forEach(n -> {
            set.add((Node)n);
            set.addAll(n.getAncestors());
        });
        return set;
    }

    public Set<Node> getDescendants() {
        HashSet<Node> set = new HashSet<Node>();
        this.getChildren().stream().filter(n -> Objects.equals(this.getNetwork(), n.getNetwork())).forEach(n -> {
            set.add((Node)n);
            set.addAll(n.getDescendants());
        });
        return set;
    }

    public static enum Field {
        nodes,
        node,
        id,
        name,
        description;

    }

    public static enum Type {
        Boolean,
        Labelled,
        Ranked,
        DiscreteReal,
        ContinuousInterval,
        IntegerInterval;

    }
}

