/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import com.agenarisk.api.exception.LinkException;
import com.agenarisk.api.exception.ModelException;
import com.agenarisk.api.exception.NetworkException;
import com.agenarisk.api.exception.NodeException;
import com.agenarisk.api.io.stub.Graphics;
import com.agenarisk.api.io.stub.Picture;
import com.agenarisk.api.io.stub.RiskTable;
import com.agenarisk.api.io.stub.Text;
import com.agenarisk.api.model.CrossNetworkLink;
import com.agenarisk.api.model.Link;
import com.agenarisk.api.model.Model;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.NodeConfiguration;
import com.agenarisk.api.model.field.Id;
import com.agenarisk.api.model.interfaces.IdContainer;
import com.agenarisk.api.model.interfaces.Identifiable;
import com.agenarisk.api.model.interfaces.Named;
import com.agenarisk.api.model.interfaces.Networked;
import com.agenarisk.api.model.interfaces.Storable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.agena.minerva.model.extendedbn.ExtendedBN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBNException;

public class Network
implements Networked<Network>,
Comparable<Network>,
Identifiable<NetworkException>,
IdContainer<NetworkException>,
Storable,
Named {
    private final Model model;
    private ExtendedBN logicNetwork;
    private JSONObject graphics;
    private JSONObject riskTable;
    private JSONObject texts;
    private JSONObject pictures;
    private final Map<Id, Node> nodes = Collections.synchronizedMap(new LinkedHashMap());

    protected static Network createNetwork(Model model, String id, String name) {
        return new Network(model, id, name);
    }

    protected static Network createNetwork(Model model, JSONObject jsonNetwork) throws JSONException, NetworkException {
        return Network.createNetwork(model, jsonNetwork, true);
    }

    protected static Network createNetwork(Model model, JSONObject jsonNetwork, boolean withTables) throws JSONException, NetworkException {
        int i;
        JSONArray jsonLinks;
        Network network;
        String id = jsonNetwork.getString(Field.id.toString());
        String name = jsonNetwork.optString(Field.name.toString());
        String description = jsonNetwork.optString(Field.description.toString());
        if (name.isEmpty()) {
            name = id;
        }
        try {
            network = model.createNetwork(id, name);
            network.setDescription(description);
        }
        catch (NetworkException ex) {
            throw new NetworkException("Failed to add a network to model", ex);
        }
        JSONArray jsonNodes = jsonNetwork.getJSONArray(Node.Field.nodes.toString());
        if (jsonNodes != null) {
            for (int i2 = 0; i2 < jsonNodes.length(); ++i2) {
                network.createNode(jsonNodes.getJSONObject(i2), false);
            }
        }
        if ((jsonLinks = jsonNetwork.optJSONArray(Link.Field.links.toString())) != null) {
            for (i = 0; i < jsonLinks.length(); ++i) {
                JSONObject jsonLink = jsonLinks.getJSONObject(i);
                String parentId = jsonLink.optString(Link.Field.parent.toString());
                String childId = jsonLink.optString(Link.Field.child.toString());
                Node parent = network.getNode(parentId);
                Node child = network.getNode(childId);
                if (parent == null) {
                    throw new NetworkException("Node `" + network.getId() + "`.`" + parentId + "` not found");
                }
                if (child == null) {
                    throw new NetworkException("Node `" + network.getId() + "`.`" + childId + "` not found");
                }
                try {
                    parent.linkTo(child);
                    continue;
                }
                catch (LinkException ex) {
                    throw new NetworkException("Failed to link nodes " + parent + " and " + child, ex);
                }
            }
        }
        if (withTables && jsonNodes != null) {
            for (i = 0; i < jsonNodes.length(); ++i) {
                JSONObject jsonNode = jsonNodes.getJSONObject(i);
                Node node = network.getNode(jsonNode.getString(Node.Field.id.toString()));
                JSONObject jsonConfiguration = jsonNode.getJSONObject(NodeConfiguration.Field.configuration.toString());
                JSONObject jsonTable = jsonConfiguration.optJSONObject(NodeConfiguration.Table.table.toString());
                try {
                    node.setTable(jsonTable);
                    continue;
                }
                catch (NodeException ex) {
                    throw new NetworkException("Failed to load table for node " + node, ex);
                }
            }
        }
        if (jsonNetwork.has(Graphics.Field.graphics.toString())) {
            network.graphics = jsonNetwork.optJSONObject(Graphics.Field.graphics.toString());
        }
        if (jsonNetwork.has(RiskTable.Field.riskTable.toString())) {
            network.riskTable = jsonNetwork.optJSONObject(RiskTable.Field.riskTable.toString());
        }
        if (jsonNetwork.has(Text.Field.texts.toString())) {
            network.texts = jsonNetwork.optJSONObject(Text.Field.texts.toString());
        }
        if (jsonNetwork.has(Picture.Field.pictures.toString())) {
            network.pictures = jsonNetwork.optJSONObject(Picture.Field.pictures.toString());
        }
        return network;
    }

    private Network(Model model, String id, String name) {
        this.model = model;
        try {
            this.logicNetwork = model.getLogicModel().addExtendedBN(name, "");
            this.logicNetwork.setConnID(id);
        }
        catch (ExtendedBNException ex) {
            throw new AgenaRiskRuntimeException("Failed to create a new network", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode(String id, String name, Node.Type type) throws NetworkException {
        Class<IdContainer> clazz = IdContainer.class;
        synchronized (IdContainer.class) {
            Node node;
            if (this.nodes.containsKey(new Id(id))) {
                throw new NetworkException("Node with id `" + id + "` already exists");
            }
            this.nodes.put(new Id(id), null);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            try {
                node = Node.createNode(this, id, name, type);
                this.nodes.put(new Id(id), node);
            }
            catch (AgenaRiskRuntimeException ex) {
                this.nodes.remove(new Id(id));
                throw new NetworkException("Failed to add node `" + id + "`", ex);
            }
            return node;
        }
    }

    public Node createNode(String id, Node.Type type) throws NetworkException {
        return this.createNode(id, id, type);
    }

    public Node createNode(JSONObject jsonNode, boolean withTables) throws NetworkException {
        Node node;
        try {
            node = Node.createNode(this, jsonNode, withTables);
        }
        catch (NodeException | JSONException ex) {
            throw new NetworkException("Failed to create Node", ex);
        }
        return node;
    }

    public Node createNode(JSONObject jsonNode) throws NetworkException {
        return this.createNode(jsonNode, true);
    }

    @Override
    public final String getId() {
        return this.getLogicNetwork().getConnID();
    }

    @Override
    public final void setId(String id) throws NetworkException {
        try {
            this.getModel().changeContainedId(this, id);
        }
        catch (ModelException ex) {
            throw new NetworkException("Failed to change ID of Network `" + this.getId() + "`", ex);
        }
        this.getLogicNetwork().setConnID(id);
    }

    public final ExtendedBN getLogicNetwork() {
        return this.logicNetwork;
    }

    public final Model getModel() {
        return this.model;
    }

    @Override
    public synchronized int compareTo(Network o) {
        return new Id(this.getId()).compareTo(new Id(o.getId()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Network)) {
            return false;
        }
        return this.getLogicNetwork() == ((Network)obj).getLogicNetwork();
    }

    public int hashCode() {
        return System.identityHashCode(this.getLogicNetwork());
    }

    public String toString() {
        return this.toStringExtra();
    }

    public String toStringExtra() {
        return "`" + this.getId() + "`";
    }

    @Override
    public Set<Network> getParents() {
        LinkedHashSet<Network> nets = new LinkedHashSet<Network>();
        this.nodes.values().forEach(node -> node.getLinksIn().stream().map(link -> link.getFromNode().getNetwork()).filter(net -> !Objects.equals(net, this)).forEachOrdered(net -> nets.add((Network)net)));
        return nets;
    }

    @Override
    public Set<Network> getChildren() {
        LinkedHashSet<Network> nets = new LinkedHashSet<Network>();
        this.nodes.values().forEach(node -> node.getLinksOut().stream().map(link -> link.getToNode().getNetwork()).filter(net -> !Objects.equals(net, this)).forEachOrdered(net -> nets.add((Network)net)));
        return nets;
    }

    @Override
    public List<Link> getLinksIn() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Link> getLinksOut() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean unlink(Network network) {
        if (Objects.equals(this, network)) {
            return false;
        }
        this.getModel().getLogicModel().removeAllMessageParsesBetweenBNs(this.getLogicNetwork(), network.getLogicNetwork());
        this.getModel().getLogicModel().removeAllMessageParsesBetweenBNs(network.getLogicNetwork(), this.getLogicNetwork());
        this.nodes.values().forEach(node -> Stream.of(node.getLinksOut().stream(), node.getLinksIn().stream()).flatMap(Function.identity()).forEachOrdered(link -> {
            boolean removeLink;
            if (!(link instanceof CrossNetworkLink)) {
                return;
            }
            boolean incoming = Objects.equals(link.getFromNode().getNetwork(), network) && Objects.equals(link.getToNode().getNetwork(), this);
            boolean outgoing = Objects.equals(link.getFromNode().getNetwork(), this) && Objects.equals(link.getToNode().getNetwork(), network);
            boolean bl = removeLink = incoming || outgoing;
            if (!removeLink) {
                return;
            }
            Node.unlinkNodes(link.getFromNode(), link.getToNode());
        }));
        return true;
    }

    @Override
    @Deprecated
    public Map<Id, ? extends Identifiable> getIdMap(Class<? extends Identifiable> idClassType) throws NetworkException {
        if (Node.class.equals(idClassType)) {
            return this.nodes;
        }
        throw new NetworkException("Invalid class type provided: " + idClassType);
    }

    @Override
    @Deprecated
    public void throwIdExistsException(String id) throws NetworkException {
        throw new NetworkException("Node with id `" + id + "` already exists");
    }

    @Override
    @Deprecated
    public void throwOldIdNullException(String id) throws NetworkException {
        throw new NetworkException("Can't change Node ID to `" + id + "` because the Node does not exist in this Network or old ID is null");
    }

    public Node getNode(String id) {
        return this.nodes.get(new Id(id));
    }

    public Map<String, Node> getNodes() {
        return this.nodes.entrySet().stream().collect(Collectors.toMap(e -> ((Id)e.getKey()).getValue(), e -> (Node)e.getValue(), (i, j) -> i, LinkedHashMap::new));
    }

    public List<Node> getNodeList() {
        return new ArrayList<Node>(this.nodes.values());
    }

    @Override
    public JSONObject toJson() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setName(String name) {
        this.getLogicNetwork().getName().setShortDescription(name);
    }

    @Override
    public String getName() {
        return this.getLogicNetwork().getName().getShortDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getLogicNetwork().getName().setLongDescription(description);
    }

    @Override
    public String getDescription() {
        return this.getLogicNetwork().getName().getLongDescription();
    }

    protected void setLogicNetwork(ExtendedBN logicNetwork) {
        if (!new Id(this.getId()).equals(new Id(logicNetwork.getConnID()))) {
            throw new AgenaRiskRuntimeException("Logic network id mismatch: " + this.getId() + "," + logicNetwork.getConnID());
        }
        this.logicNetwork = logicNetwork;
    }

    public void removeNode(Node node) throws NodeException {
        try {
            node.getParents().forEach(np -> Node.unlinkNodes(node, np));
            node.getChildren().forEach(nc -> Node.unlinkNodes(node, nc));
            this.nodes.remove(new Id(node.getId()));
            this.getLogicNetwork().removeExtendedNode(node.getLogicNode());
        }
        catch (ExtendedBNException ex) {
            throw new NodeException("Failed to remove node " + node.toStringExtra(), ex);
        }
    }

    protected void regenerateNPTs() throws NetworkException {
        this.nodes.values().stream().filter(n -> !n.isSimulated() && !n.isConnectedInput()).sorted((n1, n2) -> n1.getAncestors().size() - n2.getAncestors().size()).forEach(n -> {
            try {
                this.getLogicNetwork().regenerateNPT(n.getLogicNode());
            }
            catch (Exception ex) {
                throw new NetworkException("Failed to regenerate NPT for Node " + n.toStringExtra(), ex);
            }
        });
    }

    public static enum ModificationLog {
        modificationLog,
        entry,
        action,
        description;

    }

    public static enum Field {
        networks,
        network,
        id,
        name,
        description;

    }
}

