/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.AdapterException;
import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import com.agenarisk.api.exception.CalculationException;
import com.agenarisk.api.exception.DataSetException;
import com.agenarisk.api.exception.FileIOException;
import com.agenarisk.api.exception.InconsistentEvidenceException;
import com.agenarisk.api.exception.LinkException;
import com.agenarisk.api.exception.ModelException;
import com.agenarisk.api.exception.NetworkException;
import com.agenarisk.api.exception.NodeException;
import com.agenarisk.api.io.FileAdapter;
import com.agenarisk.api.io.JSONAdapter;
import com.agenarisk.api.io.XMLAdapter;
import com.agenarisk.api.io.stub.Audit;
import com.agenarisk.api.io.stub.Graphics;
import com.agenarisk.api.io.stub.Meta;
import com.agenarisk.api.io.stub.Picture;
import com.agenarisk.api.io.stub.RiskTable;
import com.agenarisk.api.io.stub.Text;
import com.agenarisk.api.model.CalculationResult;
import com.agenarisk.api.model.CrossNetworkLink;
import com.agenarisk.api.model.DataSet;
import com.agenarisk.api.model.Link;
import com.agenarisk.api.model.Network;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.NodeConfiguration;
import com.agenarisk.api.model.Observation;
import com.agenarisk.api.model.Settings;
import com.agenarisk.api.model.State;
import com.agenarisk.api.model.field.Id;
import com.agenarisk.api.model.interfaces.IdContainer;
import com.agenarisk.api.model.interfaces.Identifiable;
import com.agenarisk.api.model.interfaces.Storable;
import com.agenarisk.api.util.JSONUtils;
import com.singularsys.jep.JepException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.agena.minerva.model.extendedbn.ContinuousEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBNException;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.ExtendedState;
import uk.co.agena.minerva.model.questionnaire.Answer;
import uk.co.agena.minerva.model.questionnaire.Question;
import uk.co.agena.minerva.model.questionnaire.Questionnaire;
import uk.co.agena.minerva.model.scenario.ScenarioNotFoundException;
import uk.co.agena.minerva.util.Environment;
import uk.co.agena.minerva.util.Logger;
import uk.co.agena.minerva.util.StreamInterceptor;
import uk.co.agena.minerva.util.binaryfactorisation.BinaryBNConverter;
import uk.co.agena.minerva.util.io.FileHandlingException;
import uk.co.agena.minerva.util.model.ModificationLog;
import uk.co.agena.minerva.util.model.NameDescription;

public class Model
implements IdContainer<ModelException>,
Storable {
    private final Map<Id, Network> networks = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<Id, DataSet> dataSets = Collections.synchronizedMap(new LinkedHashMap());
    private uk.co.agena.minerva.model.Model logicModel;
    private JSONArray jsonTexts;
    private JSONArray jsonPictures;
    private JSONObject jsonGraphics;
    private JSONObject jsonMeta;
    private JSONObject jsonAudit;

    private Model() {
        this.initLogicModel();
    }

    private Model(uk.co.agena.minerva.model.Model api1Model) {
        this.logicModel = api1Model;
    }

    public static Model loadModel(String path) throws ModelException {
        Logger.logIfDebug((String)("Loading model from: " + path));
        if (path.matches("^\".*\"$")) {
            path = path.substring(1, path.length() - 1);
        }
        Model model = null;
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.isRegularFile(filePath, new LinkOption[0]) || !Files.isReadable(filePath)) {
            throw new ModelException("File does not exist or is not readable: " + filePath.toAbsolutePath());
        }
        if (path.toLowerCase().endsWith(".cmp") || path.toLowerCase().endsWith(".ast")) {
            try {
                model = Model.createModel(uk.co.agena.minerva.model.Model.load((String)path, (String)uk.co.agena.minerva.model.Model.suppressMessages));
            }
            catch (Exception ex) {
                throw new ModelException("Failed to convert CMP model data", ex);
            }
        }
        try {
            JSONObject json = FileAdapter.extractJSONObject(path);
            model = Model.createModel(json);
        }
        catch (AdapterException ex) {
            throw new ModelException("Model data is malformed or inacessible", ex);
        }
        catch (JSONException ex) {
            throw new ModelException("Model data is invalid", ex);
        }
        if (model == null) {
            throw new ModelException("Failed to load model from path");
        }
        if (model.getDataSets().isEmpty()) {
            Logger.logIfDebug((String)"Model has no DataSets, adding one automatically");
            model.createDataSet("Scenario 1");
        }
        Logger.logIfDebug((String)"Model loaded");
        return model;
    }

    public static Model createModel() {
        return new Model();
    }

    public static Model createModel(uk.co.agena.minerva.model.Model api1Model) throws ModelException {
        Model model;
        try {
            JSONObject json = JSONAdapter.toJSONObject(api1Model);
            model = Model.createModel(json);
        }
        catch (AdapterException ex) {
            throw new ModelException("Failed to convert minerva model to JSON", ex);
        }
        catch (JSONException ex) {
            throw new ModelException("Failed to convert minerva model to JSON: " + JSONUtils.createMissingAttrMessage(ex), ex);
        }
        model.setLogicModel(api1Model);
        model.getNetworks().forEach((netId, network) -> {
            network.setLogicNetwork(model.getLogicModel().getExtendedBNList().getExtendedBNWithConnID(netId));
            network.getNodes().forEach((nodeId, node) -> node.setLogicNode(network.getLogicNetwork().getExtendedNodeWithUniqueIdentifier(nodeId)));
        });
        model.getDataSets().forEach((dsId, ds) -> ds.setLogicScenario(model.getLogicModel().getScenarioWithName(dsId)));
        return model;
    }

    public static Model createModel(JSONObject json) throws ModelException, JSONException {
        Model model = Model.createModel();
        model.absorb(json);
        return model;
    }

    protected void absorb(JSONObject json) throws ModelException, JSONException {
        JSONArray jsonRiskTable;
        Model model = this;
        JSONObject jsonModel = json.getJSONObject(Field.model.toString());
        model.jsonTexts = jsonModel.optJSONArray(Text.Field.texts.toString());
        model.jsonPictures = jsonModel.optJSONArray(Picture.Field.pictures.toString());
        model.jsonGraphics = jsonModel.optJSONObject(Graphics.Field.graphics.toString());
        model.jsonMeta = jsonModel.optJSONObject(Meta.Field.meta.toString());
        model.jsonAudit = jsonModel.optJSONObject(Audit.Field.audit.toString());
        try {
            model.loadMetaNotes();
        }
        catch (JSONException ex) {
            throw new ModelException("Failed loading model notes", ex);
        }
        Settings.loadSettings(model, jsonModel.optJSONObject(Settings.Field.settings.toString()));
        JSONArray jsonNetworks = jsonModel.optJSONArray(Network.Field.networks.toString());
        if (jsonNetworks == null) {
            return;
        }
        for (int i = 0; i < jsonNetworks.length(); ++i) {
            model.createNetwork(jsonNetworks.getJSONObject(i), false);
        }
        try {
            Node.linkNodes(model, jsonModel.optJSONArray(Link.Field.links.toString()));
        }
        catch (LinkException | NodeException | JSONException ex) {
            throw new ModelException("Failed to link networks", ex);
        }
        ArrayList<AbstractMap.SimpleEntry<Node, Boolean>> nptStatuses = new ArrayList<AbstractMap.SimpleEntry<Node, Boolean>>();
        for (int i = 0; i < jsonNetworks.length(); ++i) {
            JSONObject jsonNetwork = jsonNetworks.getJSONObject(i);
            Network network = model.getNetwork(jsonNetwork.getString(Network.Field.id.toString()));
            JSONArray jSONArray = jsonNetwork.getJSONArray(Node.Field.nodes.toString());
            if (jSONArray == null) continue;
            for (int j = 0; j < jSONArray.length(); ++j) {
                JSONObject jsonNode = jSONArray.getJSONObject(j);
                Node node = network.getNode(jsonNode.getString(Node.Field.id.toString()));
                JSONObject jsonConfiguration = jsonNode.optJSONObject(NodeConfiguration.Field.configuration.toString());
                if (!node.isSimulated() && !node.isConnectedInput()) {
                    node.setTableUniform();
                }
                if (jsonConfiguration == null) continue;
                JSONObject jsonTable = jsonConfiguration.optJSONObject(NodeConfiguration.Table.table.toString());
                try {
                    if (!node.getLogicNode().isConnectableInputNode()) {
                        node.setTable(jsonTable);
                    }
                }
                catch (NodeException ex) {
                    throw new ModelException("Failed to load table for node " + node, ex);
                }
                boolean nptCompiled = false;
                try {
                    nptCompiled = jsonTable.optBoolean(NodeConfiguration.Table.nptCompiled.toString(), false);
                }
                catch (NullPointerException ex) {
                    Logger.logIfDebug((String)"Table missing, defaulting npt compiled to false");
                }
                nptStatuses.add(new AbstractMap.SimpleEntry<Node, Boolean>(node, nptCompiled));
            }
        }
        JSONArray jsonDataSets = jsonModel.optJSONArray(DataSet.Field.dataSets.toString());
        if (jsonDataSets != null) {
            for (int i = 0; i < jsonDataSets.length(); ++i) {
                try {
                    model.createDataSet(jsonDataSets.getJSONObject(i));
                    continue;
                }
                catch (JSONException ex) {
                    throw new ModelException("Failed to create Network", ex);
                }
            }
        }
        if ((jsonRiskTable = jsonModel.optJSONArray(RiskTable.Field.riskTable.toString())) != null) {
            model.loadRiskTable(jsonRiskTable);
        }
        for (int i = 0; i < jsonNetworks.length(); ++i) {
            JSONObject jSONObject = jsonNetworks.getJSONObject(i);
            Network network = model.getNetwork(jSONObject.getString(Network.Field.id.toString()));
            network.getLogicNetwork().resetModificationLog();
            JSONArray jsonModificationLog = jSONObject.optJSONArray(Network.ModificationLog.modificationLog.toString());
            if (jsonModificationLog == null) continue;
            for (int j = 0; j < jsonModificationLog.length(); ++j) {
                JSONObject jsonModification = jsonModificationLog.getJSONObject(j);
                String action = jsonModification.optString(Network.ModificationLog.action.toString());
                String description = jsonModification.optString(Network.ModificationLog.description.toString());
                network.getLogicNetwork().addModificationLogItem(new NameDescription(action, description));
            }
        }
        for (Map.Entry entry : nptStatuses) {
            boolean nptReCalcRequired;
            ModificationLog mods = ((Node)entry.getKey()).getNetwork().getLogicNetwork().getModificationLog();
            boolean bl = nptReCalcRequired = (Boolean)entry.getValue() == false;
            if ((mods == null || mods.getModificationItems().isEmpty()) && nptReCalcRequired) {
                ((Node)entry.getKey()).getNetwork().getLogicNetwork().addModificationLogItem(new NameDescription("Network loaded", "Network loaded"));
            }
            ((Node)entry.getKey()).getLogicNode().setNptReCalcRequired(nptReCalcRequired);
        }
    }

    private void loadMetaNotes() throws JSONException {
        if (this.jsonMeta == null || this.jsonMeta.optJSONArray(Meta.Field.notes.toString()) == null) {
            return;
        }
        JSONArray jsonNotes = this.jsonMeta.optJSONArray(Meta.Field.notes.toString());
        for (int i = 0; i < jsonNotes.length(); ++i) {
            JSONObject jsonNote = jsonNotes.getJSONObject(i);
            String name = jsonNote.getString(Meta.Field.name.toString());
            String text = jsonNote.getString(Meta.Field.name.toString());
            this.getLogicModel().getNotes().addNote(name, text);
        }
        this.jsonMeta.remove(Meta.Field.notes.toString());
    }

    public Network createNetwork(JSONObject jsonNetwork) throws NetworkException {
        return this.createNetwork(jsonNetwork, true);
    }

    public Network createNetwork(JSONObject jsonNetwork, boolean withTables) throws NetworkException {
        Network network;
        try {
            network = Network.createNetwork(this, jsonNetwork, withTables);
        }
        catch (JSONException ex) {
            throw new NetworkException("Failed to create Network", ex);
        }
        return network;
    }

    public Network createNetwork(String id) throws NetworkException {
        return this.createNetwork(id, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Network createNetwork(String id, String name) throws NetworkException {
        Class<IdContainer> clazz = IdContainer.class;
        synchronized (IdContainer.class) {
            Network network;
            if (this.networks.containsKey(new Id(id))) {
                throw new NetworkException("Network with id `" + id + "` already exists");
            }
            this.networks.put(new Id(id), null);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            try {
                network = Network.createNetwork(this, id, name);
                this.networks.put(new Id(id), network);
            }
            catch (AgenaRiskRuntimeException ex) {
                this.networks.remove(new Id(id));
                throw new NetworkException("Error in AgenaRisk Core `" + id + "`", ex);
            }
            return network;
        }
    }

    public void removeNetwork(Network net) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeNetwork(String netId) {
        this.removeNetwork(this.getNetwork(netId));
    }

    @Override
    public JSONObject toJson() {
        try {
            return JSONAdapter.toJSONObject(this.logicModel);
        }
        catch (AdapterException | JSONException ex) {
            throw new AgenaRiskRuntimeException("Failed to convert model to JSON", ex);
        }
    }

    @Override
    @Deprecated
    public Map<Id, ? extends Identifiable> getIdMap(Class<? extends Identifiable> idClassType) throws ModelException {
        if (Network.class.equals(idClassType)) {
            return this.networks;
        }
        if (DataSet.class.equals(idClassType)) {
            return this.dataSets;
        }
        throw new ModelException("Invalid class type provided: " + idClassType);
    }

    @Override
    @Deprecated
    public void throwIdExistsException(String id) throws ModelException {
        throw new ModelException("Network with ID `" + id + "` already exists");
    }

    @Override
    @Deprecated
    public void throwOldIdNullException(String id) throws ModelException {
        throw new ModelException("Can't change Network ID to `" + id + "` because the Network does not exist in this Model or old ID is null");
    }

    public Network getNetwork(String id) {
        return this.networks.get(new Id(id));
    }

    public Map<String, Network> getNetworks() {
        return this.networks.entrySet().stream().collect(Collectors.toMap(e -> ((Id)e.getKey()).getValue(), e -> (Network)e.getValue(), (i, j) -> i, LinkedHashMap::new));
    }

    public List<Network> getNetworkList() {
        return new ArrayList<Network>(this.networks.values());
    }

    public uk.co.agena.minerva.model.Model getLogicModel() {
        return this.logicModel;
    }

    public void calculate() throws CalculationException {
        Logger.logIfDebug((String)"Calculating all DataSets");
        if (this.dataSets.isEmpty()) {
            this.createDataSet("Scenario 1");
        }
        this.calculate(this.getDataSets().values());
    }

    public void calculate(Collection<DataSet> dataSets) throws CalculationException {
        this.getNetworks().values().stream().forEach(net -> {
            String s = "Calculation requested";
            net.getLogicNetwork().addModificationLogItem(new NameDescription(s, s));
        });
        StreamInterceptor.output_capture();
        String outputCaptured = "";
        try {
            this.getLogicModel().propagateDDAlgorithm(dataSets.stream().map(ds -> ds.getLogicScenario()).collect(Collectors.toList()), null, true, true);
        }
        catch (Throwable ex) {
            outputCaptured = StreamInterceptor.output_release();
            throw new CalculationException("Calculation failed", ex);
        }
        outputCaptured = outputCaptured + StreamInterceptor.output_release();
        if (!this.getLogicModel().isLastPropagationSuccessful()) {
            String message = "Calculation failed";
            if (outputCaptured.contains("Inconsistent evidence in risk object")) {
                throw new InconsistentEvidenceException("Inconsistent evidence detected (observations resulting in mutually exclusive state combinations)");
            }
            if (outputCaptured.contains("node has sum zero probability")) {
                message = outputCaptured.replaceFirst("(?s).*(?=(The entire node probability table for))", "");
                message = message.replaceFirst("(?s)(?<=(\\[Normal cannot have zero variance\\]\\.)).*", "");
                message = message.replaceAll("<br/?>", "\n");
                throw new InconsistentEvidenceException(message);
            }
            throw new CalculationException(message);
        }
    }

    public void save(String path) throws FileIOException {
        try {
            if (path.toLowerCase().endsWith(".cmp")) {
                this.getLogicModel().saveWithGraphics(path);
            } else {
                JSONObject json = JSONAdapter.toJSONObject(this.logicModel);
                String content = path.toLowerCase().endsWith(".xml") ? XMLAdapter.toXMLString(json) : json.toString();
                Files.write(Paths.get(path, new String[0]), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (AdapterException | IOException | JSONException | FileHandlingException ex) {
            throw new FileIOException("Failed to save the model", ex);
        }
    }

    public JSONObject export(ExportFlags ... flags) throws AdapterException {
        JSONObject json = JSONAdapter.toJSONObject(this.logicModel);
        EnumSet<ExportFlags> xflags = flags.length > 0 ? EnumSet.copyOf(Arrays.asList(flags)) : EnumSet.noneOf(ExportFlags.class);
        try {
            JSONObject jsonModel = json.optJSONObject(Field.model.toString());
            JSONArray jsonDataSets = jsonModel.optJSONArray(DataSet.Field.dataSets.toString());
            if (jsonDataSets != null) {
                if (jsonDataSets.length() > 0 && xflags.contains((Object)ExportFlags.CLOUD_DATASET)) {
                    JSONObject jDataSet = jsonDataSets.optJSONObject(0);
                    json.put(DataSet.Field.dataSet.toString(), (Object)jDataSet);
                    jDataSet = json.getJSONObject(DataSet.Field.dataSet.toString());
                    jDataSet.remove(CalculationResult.Field.results.toString());
                }
                if (!xflags.contains((Object)ExportFlags.KEEP_RESULTS) && !xflags.contains((Object)ExportFlags.KEEP_OBSERVATIONS)) {
                    jsonModel.remove(DataSet.Field.dataSets.toString());
                } else {
                    jsonDataSets.forEach(o -> {
                        if (o instanceof JSONObject) {
                            JSONObject jDataSet = (JSONObject)o;
                            if (!xflags.contains((Object)ExportFlags.KEEP_RESULTS)) {
                                jDataSet.remove(CalculationResult.Field.results.toString());
                            }
                            if (!xflags.contains((Object)ExportFlags.KEEP_OBSERVATIONS)) {
                                jDataSet.remove(Observation.Field.observations.toString());
                            }
                        }
                    });
                }
            }
            if (!xflags.contains((Object)ExportFlags.KEEP_RISK_TABLE)) {
                jsonModel.remove(RiskTable.Field.riskTable.toString());
            }
            if (!xflags.contains((Object)ExportFlags.KEEP_META)) {
                jsonModel.remove(Audit.Field.audit.toString());
                jsonModel.remove(Meta.Field.meta.toString());
            }
            JSONUtils.traverse(json, obj -> {
                if (obj instanceof JSONObject) {
                    JSONObject jo = (JSONObject)obj;
                    if (!xflags.contains((Object)ExportFlags.KEEP_META)) {
                        if (jo.has(Network.Field.id.toString())) {
                            jo.remove(Network.Field.name.toString());
                            jo.remove(Network.Field.description.toString());
                        }
                        jo.remove(Meta.Field.meta.toString());
                    }
                    if (!xflags.contains((Object)ExportFlags.KEEP_GRAPHICS)) {
                        jo.remove(Graphics.Field.graphics.toString());
                    }
                    jo.remove(Network.ModificationLog.modificationLog.toString());
                    if (jo.has(NodeConfiguration.Field.configuration.toString()) && jo.optJSONObject(NodeConfiguration.Field.configuration.toString()).has(NodeConfiguration.Table.table.toString())) {
                        JSONObject jsonTable = jo.optJSONObject(NodeConfiguration.Field.configuration.toString()).optJSONObject(NodeConfiguration.Table.table.toString());
                        String tableType = jsonTable.optString(NodeConfiguration.Table.type.toString());
                        boolean inputNode = jo.optJSONObject(NodeConfiguration.Field.configuration.toString()).optBoolean(NodeConfiguration.Field.input.toString(), false);
                        if (!(inputNode || Objects.equals(tableType, NodeConfiguration.TableType.Manual.toString()) || xflags.contains((Object)ExportFlags.KEEP_TABLES))) {
                            jsonTable.remove(NodeConfiguration.Table.nptCompiled.toString());
                            jsonTable.remove(NodeConfiguration.Table.probabilities.toString());
                        }
                    }
                }
            });
        }
        catch (NullPointerException | JSONException ex) {
            Logger.printThrowableIfDebug((Throwable)ex);
            return JSONAdapter.toJSONObject(this.logicModel);
        }
        return json;
    }

    public void saveEssentials(String path, boolean keepMeta) throws FileIOException {
        try {
            JSONObject json = this.export(ExportFlags.CLOUD_DATASET);
            Files.write(Paths.get(path, new String[0]), json.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (AdapterException | IOException | NullPointerException ex) {
            throw new FileIOException("Failed to save the model", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet createDataSet(String id) throws DataSetException {
        Class<IdContainer> clazz = IdContainer.class;
        synchronized (IdContainer.class) {
            if (this.dataSets.containsKey(new Id(id))) {
                throw new DataSetException("DataSet with id `" + id + "` already exists");
            }
            this.dataSets.put(new Id(id), null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            DataSet dataset = DataSet.createDataSet(this, id);
            this.dataSets.put(new Id(id), dataset);
            return dataset;
        }
    }

    protected void loadRiskTable(JSONArray jsonRiskTable) {
        this.getLogicModel().getQuestionnaireList().getQuestionnaires().clear();
        this.getLogicModel().getMetaData().getRootMetaDataItem().getConnQuestionnaireList().getQuestionnaires().clear();
        for (int i = 0; i < jsonRiskTable.length(); ++i) {
            this.loadQuestionnaire(jsonRiskTable.optJSONObject(i));
        }
        for (ExtendedBN ebn : this.getLogicModel().getExtendedBNList().getExtendedBNs()) {
            if (!this.getLogicModel().getQuestionnaireList().getQuestionnairesConnectedToExtendedBN(ebn.getId()).isEmpty()) continue;
            Questionnaire q = uk.co.agena.minerva.model.Model.createQuestionnaireFromExtendedBN((ExtendedBN)ebn);
            q.setSyncToConnectedExBNName(true);
            this.getLogicModel().getMetaData().getRootMetaDataItem().addQuestionnaire(q, this.getLogicModel());
        }
    }

    protected void loadQuestionnaire(JSONObject jsonQstnr) {
        String name = jsonQstnr.optString(RiskTable.Questionnaire.name.toString());
        String description = jsonQstnr.optString(RiskTable.Questionnaire.description.toString());
        Questionnaire qstnr = new Questionnaire(new NameDescription(name, description));
        JSONArray jsonQstns = jsonQstnr.optJSONArray(RiskTable.Question.questions.toString());
        if (jsonQstns != null) {
            for (int i = 0; i < jsonQstns.length(); ++i) {
                JSONObject jsonQstn = jsonQstns.optJSONObject(i);
                String nameQ = jsonQstn.optString(RiskTable.Question.name.toString());
                String descriptionQ = jsonQstn.optString(RiskTable.Question.description.toString());
                String netId = jsonQstn.optString(RiskTable.Question.network.toString());
                String nodeId = jsonQstn.optString(RiskTable.Question.node.toString());
                Network network = this.getNetwork(netId);
                Node node = network.getNode(nodeId);
                Question qstn = new Question(network.getLogicNetwork().getId(), node.getLogicNode().getId(), new NameDescription(nameQ, descriptionQ));
                boolean visible = jsonQstn.optBoolean(RiskTable.Question.visible.toString());
                boolean syncToConnectedNodeName = jsonQstn.optBoolean(RiskTable.Question.syncName.toString());
                qstn.setVisible(visible);
                qstn.setSyncToConnectedNodeName(syncToConnectedNodeName);
                if (node.isSimulated()) {
                    qstn.setSyncAnswersToNodeStates(true);
                }
                String questionMode = jsonQstn.optString(RiskTable.Question.mode.toString());
                String questionType = jsonQstn.optString(RiskTable.Question.type.toString());
                if (questionType.equalsIgnoreCase(RiskTable.QuestionType.constant.toString())) {
                    qstn.setRecommendedAnsweringMode(3);
                    String expressionVariableName = jsonQstn.optString(RiskTable.Question.constantName.toString());
                    qstn.setExpressionVariableName(expressionVariableName);
                } else if (questionMode.equalsIgnoreCase(RiskTable.QuestionMode.numerical.toString())) {
                    qstn.setRecommendedAnsweringMode(0);
                } else if (questionMode.equalsIgnoreCase(RiskTable.QuestionMode.unanswerable.toString())) {
                    qstn.setRecommendedAnsweringMode(2);
                } else {
                    qstn.setRecommendedAnsweringMode(1);
                }
                JSONArray jsonAnsws = jsonQstn.optJSONArray(RiskTable.Answer.answers.toString());
                if (jsonAnsws == null || jsonAnsws.length() == 0) {
                    qstn.setSyncAnswersToNodeStates(true);
                }
                boolean syncAnswers = qstn.isSyncAnswersToNodeStates();
                if (!qstn.isSyncAnswersToNodeStates()) {
                    ArrayList<Answer> answs = new ArrayList<Answer>();
                    for (int a = 0; a < jsonAnsws.length(); ++a) {
                        JSONObject jsonAnsw = jsonAnsws.optJSONObject(a);
                        String nameA = jsonAnsw.optString(RiskTable.Answer.name.toString());
                        String correspondingStateLabel = jsonAnsw.optString(RiskTable.Answer.state.toString());
                        ExtendedState correspondingState = null;
                        for (ExtendedState es : node.getLogicNode().getExtendedStates()) {
                            String computedLabel = State.computeLabel(node.getLogicNode(), es);
                            if (!computedLabel.equalsIgnoreCase(correspondingStateLabel)) continue;
                            correspondingState = es;
                            break;
                        }
                        if (correspondingState == null) {
                            syncAnswers = true;
                            break;
                        }
                        Answer answ = new Answer(correspondingState.getId(), new NameDescription(nameA, ""));
                        answs.add(answ);
                    }
                    qstn.setAnswers(answs);
                }
                if (syncAnswers) {
                    Question templateQuestion = uk.co.agena.minerva.model.Model.generateQuestionFromNode((ExtendedBN)network.getLogicNetwork(), (ExtendedNode)node.getLogicNode());
                    qstn.setAnswers(templateQuestion.getAnswers());
                }
                qstnr.addQuestion(qstn);
            }
        }
        if (!qstnr.getQuestions().isEmpty()) {
            this.getLogicModel().getQuestionnaireList().addQuestionnaire(qstnr);
            this.getLogicModel().getMetaData().getRootMetaDataItem().getConnQuestionnaireList().getQuestionnaires().add(qstnr);
        }
    }

    public DataSet createDataSet(JSONObject jsonDataSet) throws ModelException {
        DataSet dataSet;
        try {
            dataSet = DataSet.createDataSet(this, jsonDataSet);
        }
        catch (DataSetException | ModelException ex) {
            throw new ModelException("Failed to add DataSet", ex);
        }
        return dataSet;
    }

    public Map<String, DataSet> getDataSets() {
        return this.dataSets.entrySet().stream().collect(Collectors.toMap(e -> ((Id)e.getKey()).getValue(), e -> (DataSet)e.getValue(), (i, j) -> i, LinkedHashMap::new));
    }

    public List<DataSet> getDataSetList() {
        return new ArrayList<DataSet>(this.dataSets.values());
    }

    public Link createLink(Node source, Node target, CrossNetworkLink.Type type) throws LinkException {
        return Node.linkNodes(source, source, type);
    }

    public Link createLink(String sourceNetworkId, String sourceNodeId, String targetNetworkId, String targetNodeId, CrossNetworkLink.Type type) throws LinkException {
        Node source = this.getNetwork(sourceNetworkId).getNode(sourceNodeId);
        Node target = this.getNetwork(targetNetworkId).getNode(targetNodeId);
        return this.createLink(source, target, type);
    }

    public Link createLink(Node source, Node target, State state) throws LinkException {
        return Node.linkNodes(source, target, CrossNetworkLink.Type.State, state.getLabel());
    }

    public Link createLink(String sourceNetworkId, String sourceNodeId, String targetNetworkId, String targetNodeId, String stateLabel) throws ModelException {
        Node source = this.getNetwork(sourceNetworkId).getNode(sourceNodeId);
        Node target = this.getNetwork(targetNetworkId).getNode(targetNodeId);
        return Node.linkNodes(source, target, CrossNetworkLink.Type.State, stateLabel);
    }

    public JSONArray getJsonTexts() {
        return this.jsonTexts;
    }

    public JSONArray getJsonPictures() {
        return this.jsonPictures;
    }

    public JSONObject getJsonGraphics() {
        return this.jsonGraphics;
    }

    public JSONObject getJsonAudit() {
        return this.jsonAudit;
    }

    protected void setLogicModel(uk.co.agena.minerva.model.Model logicModel) {
        this.logicModel = logicModel;
    }

    public DataSet getDataSet(String id) {
        return this.dataSets.get(new Id(id));
    }

    public boolean factorize() throws ModelException {
        BinaryBNConverter converter = new BinaryBNConverter(this.getLogicModel(), false);
        List<Network> networksList = this.getNetworkList();
        ArrayList<ExtendedBN> bnList = new ArrayList<ExtendedBN>();
        Boolean[] factorizeFlags = new Boolean[this.networks.size()];
        boolean factorizeAny = false;
        for (int i = 0; i < this.networks.size(); ++i) {
            Network net = networksList.get(i);
            try {
                net.getLogicNetwork().checkExpressions();
            }
            catch (JepException | ExtendedBNException ex) {
                throw new ModelException("Can't factorize the model due to invalid expression", ex);
            }
            bnList.add(net.getLogicNetwork());
            boolean factorize = net.getNodes().values().stream().anyMatch(node -> {
                ContinuousEN cien;
                if (!node.isSimulated() || node.getLinksIn().size() <= 2) {
                    return false;
                }
                if (!node.getTableType().equals((Object)NodeConfiguration.TableType.Expression)) {
                    return false;
                }
                if (node.getLogicNode() instanceof ContinuousEN && (cien = (ContinuousEN)node.getLogicNode()).checkExpressionToDetectComplexFunction()) {
                    return false;
                }
                Set<Node> parents = node.getParents();
                return parents.stream().filter(Node::isSimulated).count() > 2L;
            });
            factorizeFlags[i] = factorize;
            if (!factorize) continue;
            factorizeAny = true;
        }
        if (!factorizeAny) {
            return false;
        }
        JSONObject settingsOriginal = Settings.toJson(this.logicModel);
        try {
            converter.convertBNList(bnList, this.logicModel, factorizeFlags);
            uk.co.agena.minerva.model.Model binaryModel = uk.co.agena.minerva.model.Model.load((String)this.logicModel.getFactorizedBFModelPath());
            JSONObject jsonBinary = JSONAdapter.toJSONObject(binaryModel);
            this.reset();
            this.absorb(jsonBinary);
            Settings.loadSettings(this, settingsOriginal);
        }
        catch (Exception ex) {
            throw new ModelException("Failed to factorize", ex);
        }
        return true;
    }

    public boolean removeDataSet(DataSet dataSet) {
        try {
            this.logicModel.removeScenario(dataSet.getLogicScenario());
            this.dataSets.remove(new Id(dataSet.getId()));
        }
        catch (ScenarioNotFoundException ex) {
            return false;
        }
        return true;
    }

    public void convertToStatic(DataSet dataSet) throws NodeException {
        this.getNetworks().values().forEach(network -> network.getNodes().values().forEach(node -> {
            if (node.isSimulated()) {
                node.convertToStatic(dataSet);
            }
        }));
    }

    public void reset() {
        this.networks.clear();
        this.dataSets.clear();
        this.jsonTexts = null;
        this.jsonPictures = null;
        this.jsonGraphics = null;
        this.jsonMeta = null;
        this.jsonAudit = null;
        this.initLogicModel();
    }

    private void initLogicModel() {
        String outputMode = "system";
        if (Environment.isGuiMode()) {
            outputMode = "all";
        }
        try {
            this.logicModel = uk.co.agena.minerva.model.Model.createEmptyModel((String)outputMode);
            this.logicModel.removeExtendedBNs(this.logicModel.getExtendedBNAtIndex(0), true);
            this.logicModel.removeScenario(this.logicModel.getScenarioAtIndex(0));
        }
        catch (uk.co.agena.minerva.model.ModelException | ScenarioNotFoundException ex) {
            throw new AgenaRiskRuntimeException("Failed to initialise the model", ex);
        }
    }

    public Settings getSettings() {
        return new Settings(this);
    }

    public boolean isCalculated() {
        if (!this.getLogicModel().isLastPropagationSuccessful()) {
            return false;
        }
        for (Network net : this.networks.values()) {
            try {
                boolean netModified = net.getLogicNetwork().getModificationLog().getModificationItems().isEmpty();
                if (!netModified) continue;
                return false;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return true;
    }

    public static enum ExportFlags {
        KEEP_META,
        KEEP_RESULTS,
        KEEP_OBSERVATIONS,
        KEEP_RISK_TABLE,
        KEEP_GRAPHICS,
        KEEP_TABLES,
        CLOUD_DATASET;

    }

    public static enum Field {
        model;

    }
}

