/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.LinkException;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.interfaces.Storable;
import com.singularsys.jep.JepException;
import java.util.List;
import java.util.Objects;
import org.json.JSONObject;
import uk.co.agena.minerva.model.corebn.CoreBNException;
import uk.co.agena.minerva.model.extendedbn.ExtendedBNException;

public class Link
implements Comparable<Link>,
Storable {
    private final Node fromNode;
    private final Node toNode;
    private JSONObject graphics;

    @Deprecated
    protected Link(Node fromNode, Node toNode) {
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    protected static Link createLink(Node fromNode, Node toNode) throws LinkException {
        if (!Objects.equals(fromNode.getNetwork(), toNode.getNetwork())) {
            throw new LinkException("Nodes must be in the same network for simple link");
        }
        return new Link(fromNode, toNode);
    }

    protected void createLogicLink() throws LinkException {
        block5: {
            try {
                boolean created;
                List existing = this.fromNode.getNetwork().getLogicNetwork().getChildNodes(this.fromNode.getLogicNode());
                if (existing.contains(this.toNode.getLogicNode())) {
                    throw new LinkException("Link already exists");
                }
                if (this.toNode.getLogicNode().isConnectableInputNode() && this.toNode.getLinksIn().isEmpty()) {
                    this.toNode.getLogicNode().setConnectableInputNode(false);
                }
                if (!(created = this.fromNode.getLogicNode().addChild(this.toNode.getLogicNode()))) {
                    throw new LinkException("Logic network failure while linking nodes");
                }
            }
            catch (ExtendedBNException ex) {
                if (!(ex.getCause() instanceof CoreBNException)) break block5;
                throw new LinkException("Logic node with ID `" + this.fromNode.getId() + "` or `" + this.toNode.getId() + "` not found", ex);
            }
        }
    }

    protected void destroyLogicLink() {
        try {
            this.fromNode.getNetwork().getLogicNetwork().removeRelationship(this.fromNode.getLogicNode(), this.toNode.getLogicNode(), false);
        }
        catch (ExtendedBNException ex) {
            if (ex.getCause() instanceof CoreBNException) {
                throw new LinkException("Logic node with ID `" + this.fromNode.getId() + "` or `" + this.toNode.getId() + "` not found in network `" + this.fromNode.getNetwork().getId() + "`", ex);
            }
            throw new LinkException("CoreBN missing");
        }
        catch (JepException jepException) {
            // empty catch block
        }
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public Node getToNode() {
        return this.toNode;
    }

    public String toString() {
        return this.toStringExtra();
    }

    public String toStringExtra() {
        return this.fromNode.toStringExtra() + " -> " + this.toNode.toStringExtra();
    }

    @Override
    public synchronized int compareTo(Link o) {
        return this.toStringExtra().compareTo(o.toStringExtra());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Link)) {
            return false;
        }
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    protected void setGraphics(JSONObject graphics) {
        this.graphics = graphics;
    }

    @Override
    public JSONObject toJson() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum Field {
        links,
        link,
        parent,
        child;

    }
}

