/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.model;

import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import com.agenarisk.api.exception.DataSetException;
import com.agenarisk.api.exception.ModelException;
import com.agenarisk.api.model.CalculationResult;
import com.agenarisk.api.model.Model;
import com.agenarisk.api.model.Network;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.Observation;
import com.agenarisk.api.model.VariableObservation;
import com.agenarisk.api.model.field.Id;
import com.agenarisk.api.model.interfaces.Identifiable;
import com.agenarisk.api.model.interfaces.Storable;
import com.agenarisk.api.util.Advisory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.agena.minerva.model.MarginalDataItem;
import uk.co.agena.minerva.model.extendedbn.BooleanEN;
import uk.co.agena.minerva.model.extendedbn.ContinuousIntervalEN;
import uk.co.agena.minerva.model.extendedbn.DiscreteRealEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBN;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.ExtendedState;
import uk.co.agena.minerva.model.extendedbn.ExtendedStateNotFoundException;
import uk.co.agena.minerva.model.extendedbn.IntegerIntervalEN;
import uk.co.agena.minerva.model.extendedbn.LabelledEN;
import uk.co.agena.minerva.model.extendedbn.RankedEN;
import uk.co.agena.minerva.model.scenario.ObservationNotFoundException;
import uk.co.agena.minerva.model.scenario.Scenario;
import uk.co.agena.minerva.model.scenario.ScenarioException;
import uk.co.agena.minerva.util.model.NameDescription;

public class DataSet
implements Identifiable<DataSetException>,
Storable {
    private final Model model;
    private Scenario logicScenario;

    private DataSet(Model model, Scenario logicScenario) {
        this.model = model;
        this.logicScenario = logicScenario;
    }

    protected static DataSet createDataSet(Model model, String id) {
        Scenario logicScenario = new Scenario(new NameDescription(id, id));
        model.getLogicModel().getMetaData().getRootMetaDataItem().addScenario(logicScenario, model.getLogicModel());
        DataSet dataset = new DataSet(model, logicScenario);
        return dataset;
    }

    protected static DataSet createDataSet(Model model, JSONObject jsonDataSet) throws ModelException, DataSetException {
        DataSet dataSet;
        boolean someFailed = false;
        try {
            String idOriginal;
            String id = idOriginal = jsonDataSet.getString(Field.id.toString());
            int i = 1;
            while (model.getDataSets().get(id) != null) {
                id = idOriginal + "_" + i++;
            }
            dataSet = model.createDataSet(id);
        }
        catch (JSONException ex) {
            throw new ModelException("Failed reading dataset data", ex);
        }
        dataSet.getLogicScenario().setReportable(jsonDataSet.optBoolean(Field.active.toString(), true));
        dataSet.getLogicScenario().setDisplayOnRiskGraphs(jsonDataSet.optBoolean(Field.displayable.toString(), true));
        if (jsonDataSet.has(Observation.Field.observations.toString())) {
            JSONArray jsonObservations;
            try {
                jsonObservations = jsonDataSet.getJSONArray(Observation.Field.observations.toString());
            }
            catch (JSONException ex) {
                throw new ModelException("Failed reading observation data", ex);
            }
            for (int i = 0; i < jsonObservations.length(); ++i) {
                JSONObject jsonObservation = jsonObservations.optJSONObject(i);
                try {
                    dataSet.setObservation(jsonObservation);
                    continue;
                }
                catch (Exception ex) {
                    if (Advisory.getCurrentThreadGroup() != null) {
                        String networkId = jsonObservation.optString(Observation.Field.network.toString());
                        String nodeId = jsonObservation.optString(Observation.Field.node.toString());
                        String message = "Failed loading observation";
                        if (nodeId != null) {
                            message = message + " for node `" + nodeId + "`";
                            if (networkId != null) {
                                message = message + " in network `" + networkId + "`";
                            }
                        }
                        Advisory.getCurrentThreadGroup().addMessage(new Advisory.AdvisoryMessage(message, ex));
                        continue;
                    }
                    someFailed = true;
                }
            }
        }
        if (someFailed) {
            return dataSet;
        }
        if (jsonDataSet.has(CalculationResult.Field.results.toString())) {
            try {
                JSONArray jsonResults = jsonDataSet.getJSONArray(CalculationResult.Field.results.toString());
                for (int i = 0; i < jsonResults.length(); ++i) {
                    JSONObject jsonResult = jsonResults.optJSONObject(i);
                    dataSet.loadCalculationResult(jsonResult);
                }
            }
            catch (DataSetException | JSONException ex) {
                throw new ModelException("Failed to read results data", ex);
            }
        }
        return dataSet;
    }

    public final Scenario getLogicScenario() {
        return this.logicScenario;
    }

    protected void setLogicScenario(Scenario logicScenario) {
        if (!new Id(this.getId()).equals(new Id(logicScenario.getName().getShortDescription()))) {
            throw new AgenaRiskRuntimeException("Logic scenario id mismatch: " + this.getId() + "," + logicScenario.getName().getShortDescription());
        }
        this.logicScenario = logicScenario;
    }

    public final Model getModel() {
        return this.model;
    }

    @Override
    public final String getId() {
        return this.getLogicScenario().getName().getShortDescription();
    }

    @Override
    public final void setId(String id) throws DataSetException {
        try {
            this.getModel().changeContainedId(this, id);
        }
        catch (ModelException ex) {
            throw new DataSetException("Failed to change ID of Network `" + this.getId() + "`", ex);
        }
        this.getLogicScenario().setName(new NameDescription(id, id));
    }

    public void setObservationHard(Node node, int value) throws DataSetException {
        try {
            this.setObservation(node, value);
        }
        catch (Exception ex) {
            throw new DataSetException("Failed to set observation for node " + node, ex);
        }
    }

    public void setObservationHard(Node node, double value) throws DataSetException {
        try {
            this.setObservation(node, value);
        }
        catch (Exception ex) {
            throw new DataSetException("Failed to set observation for node " + node, ex);
        }
    }

    public void setObservationHard(Node node, String state) throws DataSetException {
        try {
            this.setObservation(node, state);
        }
        catch (Exception ex) {
            throw new DataSetException("Failed to set observation for node " + node, ex);
        }
    }

    protected void setObservationConstant(Node node, String constantName, double value) throws DataSetException {
        ExtendedBN ebn = node.getNetwork().getLogicNetwork();
        ExtendedNode en = node.getLogicNode();
        if (!node.getNetwork().getModel().equals(this.getModel())) {
            throw new DataSetException("Node and DataSet belong to different models");
        }
        uk.co.agena.minerva.util.model.DataSet ds = new uk.co.agena.minerva.util.model.DataSet();
        uk.co.agena.minerva.model.scenario.Observation observation = new uk.co.agena.minerva.model.scenario.Observation(ebn.getId(), en.getId(), 0, ds, uk.co.agena.minerva.model.scenario.Observation.OBSERVATION_TYPE_EXPRESSION_VARIABLE, value + "", en.getConnNodeId(), en.getExtendedStates().size());
        observation.setExpressionVariableName(constantName);
        this.getLogicScenario().addObservation(observation, false);
    }

    public void setObservation(Node node, Object value) throws DataSetException {
        ExtendedBN ebn = node.getNetwork().getLogicNetwork();
        ExtendedNode en = node.getLogicNode();
        if (!node.getNetwork().getModel().equals(this.getModel())) {
            throw new DataSetException("Node and DataSet belong to different models");
        }
        if (en instanceof BooleanEN && value instanceof Boolean) {
            value = String.valueOf(value);
        }
        if (en instanceof DiscreteRealEN && value instanceof Double) {
            value = String.valueOf(value);
        }
        if (en instanceof DiscreteRealEN && value instanceof Integer) {
            value = String.valueOf(Double.valueOf(value + ""));
        }
        if (en instanceof LabelledEN || en instanceof RankedEN || en instanceof DiscreteRealEN) {
            if (value instanceof String) {
                ExtendedState state = null;
                try {
                    state = en.getExtendedStateWithShortDesc((String)value);
                    this.getLogicScenario().addHardEvidenceObservation(ebn.getId(), en.getId(), state.getId());
                }
                catch (ExtendedStateNotFoundException ex) {
                    throw new DataSetException("State `" + value + "` does not exist in node " + node.toStringExtra(), ex);
                }
            }
        } else if (en instanceof ContinuousIntervalEN || en instanceof IntegerIntervalEN) {
            try {
                Double.valueOf(String.valueOf(value));
            }
            catch (NumberFormatException ex) {
                throw new DataSetException("Invalid observation value - not a number", ex);
            }
            uk.co.agena.minerva.model.scenario.Observation obs = new uk.co.agena.minerva.model.scenario.Observation(ebn.getId(), en.getId(), -1, new uk.co.agena.minerva.util.model.DataSet(new NameDescription("", ""), en.getId()), uk.co.agena.minerva.model.scenario.Observation.OBSERVATION_TYPE_NUMERIC, String.valueOf(value));
            this.getLogicScenario().addObservation(obs, false);
        } else {
            throw new DataSetException("Unsupported observation type");
        }
    }

    public void setObservationSoft(Node node, String[] states, Double[] weights) throws DataSetException {
        if (states.length != weights.length) {
            throw new DataSetException("Arrays length not equal");
        }
        Map entries = IntStream.range(0, states.length).boxed().collect(Collectors.toMap(i -> states[i], i -> weights[i], (k1, k2) -> k2, LinkedHashMap::new));
        try {
            this.setObservationSoft(node, entries);
        }
        catch (Exception ex) {
            throw new DataSetException("Failed to set observation for node " + node, ex);
        }
    }

    public void setObservationSoft(Node node, Map<String, Double> weights) throws DataSetException {
        if (!node.getNetwork().getModel().equals(this.getModel())) {
            throw new DataSetException("Node and DataSet belong to different models");
        }
        int netId = node.getNetwork().getLogicNetwork().getId();
        int nodeId = node.getLogicNode().getId();
        double[] probabilities = new double[weights.size()];
        int[] stateIds = new int[weights.size()];
        int i = 0;
        for (String stateName : weights.keySet()) {
            ExtendedState es = node.getLogicNode().getExtendedStateWithName(stateName);
            if (es == null) {
                throw new DataSetException("State `" + stateName + "` not found");
            }
            stateIds[i] = es.getId();
            probabilities[i] = weights.get(stateName);
            ++i;
        }
        try {
            this.getLogicScenario().addSoftEvidenceObservation(netId, nodeId, stateIds, probabilities);
        }
        catch (ScenarioException ex) {
            throw new DataSetException("Failed to add soft observation", ex);
        }
    }

    public void setObservation(JSONObject jsonObservation) throws DataSetException, JSONException {
        Node node;
        String networkId = jsonObservation.getString(Observation.Field.network.toString());
        String nodeId = jsonObservation.getString(Observation.Field.node.toString());
        try {
            node = this.model.getNetwork(networkId).getNode(nodeId);
        }
        catch (NullPointerException ex) {
            throw new DataSetException("Network or node not found", ex);
        }
        JSONArray jsonEntries = jsonObservation.getJSONArray(Observation.Field.entries.toString());
        LinkedHashMap<String, Double> entries = new LinkedHashMap<String, Double>();
        for (int i = 0; i < jsonEntries.length(); ++i) {
            JSONObject jsonEntry = jsonEntries.getJSONObject(i);
            String value = jsonEntry.get(Observation.Field.value.toString()) + "";
            Double weight = jsonEntry.getDouble(Observation.Field.weight.toString());
            if (jsonEntries.length() == 1) {
                if (jsonObservation.has(Observation.Field.constantName.toString())) {
                    this.setObservationConstant(node, jsonObservation.getString(Observation.Field.constantName.toString()), Double.valueOf(value));
                    return;
                }
                try {
                    this.setObservation(node, value);
                }
                catch (Exception ex) {
                    throw new DataSetException("Failed to set observation for node " + node, ex);
                }
                return;
            }
            entries.put(String.valueOf(value), weight);
        }
        try {
            this.setObservationSoft(node, entries);
        }
        catch (Exception ex) {
            throw new DataSetException("Failed to set observation for node " + node, ex);
        }
    }

    public boolean hasVariableObservation(Node node, String variableName) {
        List obss = this.getLogicScenario().getObservations(node.getNetwork().getLogicNetwork().getId(), node.getLogicNode().getId());
        return obss.stream().anyMatch(obs -> StringUtils.equalsIgnoreCase((CharSequence)variableName, (CharSequence)obs.getExpressionVariableName()));
    }

    public void setVariableObservation(Node node, String variableName, double value) throws DataSetException {
        this.setObservationConstant(node, variableName, value);
    }

    public Set<VariableObservation> getVariableObservations(Node node) {
        LinkedHashSet<VariableObservation> varObss = new LinkedHashSet<VariableObservation>();
        this.getLogicScenario().getObservations(node.getNetwork().getLogicNetwork().getId(), node.getLogicNode().getId()).stream().filter(obs -> obs.getExpressionVariableName() != null && !obs.getExpressionVariableName().isEmpty()).map(obs -> new VariableObservation((uk.co.agena.minerva.model.scenario.Observation)obs, this, node)).collect(Collectors.toCollection(() -> varObss));
        return varObss;
    }

    public VariableObservation getVariableObservation(Node node, String variableName) {
        return this.getVariableObservations(node).stream().filter(obs -> StringUtils.equalsIgnoreCase((CharSequence)variableName, (CharSequence)obs.getVariableName())).findFirst().orElse(null);
    }

    public Set<VariableObservation> getVariableObservations() {
        LinkedHashSet<VariableObservation> varObss = new LinkedHashSet<VariableObservation>();
        this.getModel().getNetworks().values().forEach(net -> net.getNodes().values().stream().forEach(node -> varObss.addAll(this.getVariableObservations((Node)node))));
        return varObss;
    }

    public void clearVariableObservation(Node node, String variableName) {
        VariableObservation varObs = this.getVariableObservation(node, variableName);
        if (varObs != null) {
            this.getLogicScenario().removeObservation(varObs.getLogicObservation(), false);
        }
    }

    public void clearVariableObservations(Node node) {
        this.getVariableObservations(node).forEach(obs -> this.getLogicScenario().removeObservation(obs.getLogicObservation(), false));
    }

    public void clearVariableObservations() {
        ArrayList obss = new ArrayList(this.getLogicScenario().getObservations());
        obss.stream().filter(obs -> !obs.getExpressionVariableName().isEmpty()).forEach(obs -> this.getLogicScenario().removeObservation(obs, false));
    }

    public void clearAllData() {
        this.getLogicScenario().clearAllObservations(false);
        int index = this.getDataSetIndex();
        this.getModel().getLogicModel().getMarginalDataStore().getNodeMarginalListMap().values().forEach(mdil -> {
            MarginalDataItem mdiNew = new MarginalDataItem(this.getId());
            mdiNew.setVisible(this.getLogicScenario().isReportable());
            mdiNew.setCallSignToUpdateOn(Integer.toString(this.getLogicScenario().getId()));
            if (mdil.getMarginalDataItems().size() - 1 >= index) {
                MarginalDataItem mdiCurrent = mdil.getMarginalDataItemAtIndex(index);
                mdiNew.setOnlyUpdateOnMatchedCallSign(mdiCurrent.isOnlyUpdateOnMatchedCallSign());
                mdiNew.setUpdateOnAllEvidenceRetracted(mdiCurrent.isUpdateOnAllEvidenceRetracted());
            } else {
                for (int i = mdil.getMarginalDataItems().size(); i <= index; ++i) {
                    mdil.getMarginalDataItems().add(null);
                }
            }
            mdil.getMarginalDataItems().set(index, mdiNew);
        });
    }

    public void clearObservation(Node node) {
        Observation obs = this.getObservation(node);
        if (obs != null) {
            this.getLogicScenario().removeObservation(obs.getLogicObservation(), false);
        }
    }

    public void clearObservations() {
        ArrayList obss = new ArrayList(this.getLogicScenario().getObservations());
        obss.stream().filter(obs -> obs.getExpressionVariableName() == null || obs.getExpressionVariableName().isEmpty()).forEach(obs -> this.getLogicScenario().removeObservation(obs, false));
    }

    public boolean hasObservation(Node node) {
        try {
            this.getLogicScenario().getObservation(node.getNetwork().getLogicNetwork().getId(), node.getLogicNode().getId());
        }
        catch (ObservationNotFoundException ex) {
            return false;
        }
        return true;
    }

    public Set<Observation> getObservationsAndVariables(Node node) {
        LinkedHashSet<Observation> observations = new LinkedHashSet<Observation>();
        if (this.hasObservation(node)) {
            observations.add(this.getObservation(node));
        }
        observations.addAll(this.getVariableObservations(node));
        return observations;
    }

    public Set<Observation> getObservationsAndVariables() {
        LinkedHashSet<Observation> observations = new LinkedHashSet<Observation>();
        observations.addAll(this.getObservations());
        observations.addAll(this.getVariableObservations());
        return observations;
    }

    public Set<Observation> getObservations() {
        LinkedHashSet<Observation> observations = new LinkedHashSet<Observation>();
        this.getModel().getNetworks().values().forEach(net -> net.getNodes().values().stream().filter(node -> this.hasObservation((Node)node)).map(node -> this.getObservation((Node)node)).collect(Collectors.toCollection(() -> observations)));
        return observations;
    }

    public Observation getObservation(Node node) {
        uk.co.agena.minerva.model.scenario.Observation logicObservation = null;
        try {
            logicObservation = this.getLogicScenario().getObservation(node.getNetwork().getLogicNetwork().getId(), node.getLogicNode().getId());
        }
        catch (ObservationNotFoundException observationNotFoundException) {
            // empty catch block
        }
        if (logicObservation == null) {
            return null;
        }
        return new Observation(logicObservation, this, node);
    }

    public CalculationResult getCalculationResult(Node node) {
        return CalculationResult.getCalculationResult(this, node);
    }

    public List<CalculationResult> getCalculationResults() {
        return this.getModel().getNetworks().values().stream().flatMap(network -> this.getCalculationResults((Network)network).values().stream()).collect(Collectors.toList());
    }

    public Map<Node, CalculationResult> getCalculationResults(Network network) {
        return network.getNodes().values().stream().collect(Collectors.toMap(node -> node, node -> CalculationResult.getCalculationResult(this, node)));
    }

    public void loadCalculationResult(JSONObject jsonResult) throws DataSetException, JSONException {
        CalculationResult.loadCalculationResult(this, jsonResult);
    }

    protected int getDataSetIndex() {
        Scenario scenario;
        String thiScenarioName = this.logicScenario.getName().getShortDescription();
        int index = 0;
        Iterator iterator = this.getModel().getLogicModel().getScenarioList().getScenarios().iterator();
        while (iterator.hasNext() && !thiScenarioName.equalsIgnoreCase((scenario = (Scenario)iterator.next()).getName().getShortDescription())) {
            ++index;
        }
        return index;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonDataSet = new JSONObject();
        jsonDataSet.put(Field.id.toString(), (Object)this.getId());
        jsonDataSet.put(Field.active.toString(), this.getLogicScenario().isReportable());
        jsonDataSet.put(Field.displayable.toString(), this.getLogicScenario().isDisplayOnRiskGraphs());
        JSONArray jsonObservations = new JSONArray();
        this.getObservations().stream().forEach(obs -> jsonObservations.put((Object)obs.toJson()));
        jsonDataSet.put(Observation.Field.observations.toString(), (Object)jsonObservations);
        jsonDataSet.put(Field.active.toString(), this.logicScenario.isReportable());
        jsonDataSet.put(Field.displayable.toString(), this.logicScenario.isDisplayOnRiskGraphs());
        JSONArray jsonResults = new JSONArray();
        this.getCalculationResults().stream().forEach(cr -> jsonResults.put((Object)cr.toJson()));
        jsonDataSet.put(CalculationResult.Field.results.toString(), (Object)jsonResults);
        return jsonDataSet;
    }

    public static enum Field {
        dataSets,
        dataSet,
        id,
        active,
        displayable;

    }
}

