/*
 * Decompiled with CFR 0.152.
 */
package com.agenarisk.api.io;

import com.agenarisk.api.exception.AdapterException;
import com.agenarisk.api.exception.AgenaRiskRuntimeException;
import com.agenarisk.api.io.stub.Meta;
import com.agenarisk.api.io.stub.NodeGraphics;
import com.agenarisk.api.io.stub.RiskTable;
import com.agenarisk.api.io.stub.SummaryStatistic;
import com.agenarisk.api.model.CalculationResult;
import com.agenarisk.api.model.CrossNetworkLink;
import com.agenarisk.api.model.DataSet;
import com.agenarisk.api.model.Link;
import com.agenarisk.api.model.Model;
import com.agenarisk.api.model.Network;
import com.agenarisk.api.model.Node;
import com.agenarisk.api.model.NodeConfiguration;
import com.agenarisk.api.model.Observation;
import com.agenarisk.api.model.ResultValue;
import com.agenarisk.api.model.Settings;
import com.agenarisk.api.model.State;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.agena.minerva.model.ConstantStateMessagePassingLink;
import uk.co.agena.minerva.model.ConstantSummaryMessagePassingLink;
import uk.co.agena.minerva.model.MarginalDataItem;
import uk.co.agena.minerva.model.MessagePassingLink;
import uk.co.agena.minerva.model.MessagePassingLinks;
import uk.co.agena.minerva.model.Model;
import uk.co.agena.minerva.model.extendedbn.ContinuousEN;
import uk.co.agena.minerva.model.extendedbn.DiscreteRealEN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBN;
import uk.co.agena.minerva.model.extendedbn.ExtendedBNException;
import uk.co.agena.minerva.model.extendedbn.ExtendedBNNotFoundException;
import uk.co.agena.minerva.model.extendedbn.ExtendedNode;
import uk.co.agena.minerva.model.extendedbn.ExtendedNodeFunction;
import uk.co.agena.minerva.model.extendedbn.ExtendedNodeNotFoundException;
import uk.co.agena.minerva.model.extendedbn.ExtendedState;
import uk.co.agena.minerva.model.extendedbn.ExtendedStateNotFoundException;
import uk.co.agena.minerva.model.extendedbn.LabelledEN;
import uk.co.agena.minerva.model.extendedbn.NumericalEN;
import uk.co.agena.minerva.model.extendedbn.RankedEN;
import uk.co.agena.minerva.model.questionnaire.Answer;
import uk.co.agena.minerva.model.questionnaire.Question;
import uk.co.agena.minerva.model.questionnaire.Questionnaire;
import uk.co.agena.minerva.model.scenario.Observation;
import uk.co.agena.minerva.model.scenario.Scenario;
import uk.co.agena.minerva.util.Logger;
import uk.co.agena.minerva.util.model.DataPoint;
import uk.co.agena.minerva.util.model.DataSet;
import uk.co.agena.minerva.util.model.IntervalDataPoint;
import uk.co.agena.minerva.util.model.ModificationLog;
import uk.co.agena.minerva.util.model.Note;
import uk.co.agena.minerva.util.model.Variable;

public class JSONAdapter {
    public static final boolean CACHE_NPTS = true;

    public static JSONObject toJSONObject(Model model) throws JSONException, AdapterException {
        JSONObject json = new JSONObject();
        JSONObject jsonModel = new JSONObject();
        json.put(Model.Field.model.toString(), (Object)jsonModel);
        jsonModel.put(Network.Field.networks.toString(), (Object)JSONAdapter.modelNetworksToJSON(model));
        jsonModel.put(Link.Field.links.toString(), (Object)JSONAdapter.modelLinksToJSON(model));
        jsonModel.put(Settings.Field.settings.toString(), (Object)Settings.toJson(model));
        jsonModel.put(DataSet.Field.dataSets.toString(), (Object)JSONAdapter.modelScenariosToJSON(model));
        if (!model.getNotes().getNotes().isEmpty()) {
            jsonModel.put(Meta.Field.meta.toString(), (Object)JSONAdapter.modelMetaToJSON(model));
        }
        jsonModel.put(RiskTable.Field.riskTable.toString(), (Object)JSONAdapter.modelRiskTableToJSON(model));
        return json;
    }

    protected static JSONArray modelScenariosToJSON(Model model) throws JSONException {
        JSONArray jsonDataSets = new JSONArray();
        int scenarioCount = model.getScenarioList().getScenarios().size();
        for (int i = 0; i < scenarioCount; ++i) {
            JSONObject jsonDataSet = JSONAdapter.scenarioToJSON(model, model.getScenarioAtIndex(i));
            jsonDataSets.put((Object)jsonDataSet);
        }
        return jsonDataSets;
    }

    protected static JSONObject scenarioToJSON(Model model, Scenario scenario) throws JSONException {
        JSONObject jsonDataSet = new JSONObject();
        jsonDataSet.put(DataSet.Field.id.toString(), (Object)scenario.getName().getShortDescription());
        JSONArray jsonObservations = new JSONArray();
        for (Observation observation : scenario.getObservations()) {
            try {
                jsonObservations.put((Object)JSONAdapter.observationToJSON(model, observation));
            }
            catch (ExtendedBNNotFoundException | ExtendedNodeNotFoundException | ExtendedStateNotFoundException ex) {
                Logger.printThrowableIfDebug((Throwable)ex);
            }
        }
        jsonDataSet.put(Observation.Field.observations.toString(), (Object)jsonObservations);
        jsonDataSet.put(DataSet.Field.active.toString(), scenario.isReportable());
        jsonDataSet.put(DataSet.Field.displayable.toString(), scenario.isDisplayOnRiskGraphs());
        JSONArray jsonResults = JSONAdapter.resultsToJSON(model, scenario);
        jsonDataSet.put(CalculationResult.Field.results.toString(), (Object)jsonResults);
        return jsonDataSet;
    }

    protected static JSONArray resultsToJSON(Model model, Scenario scenario) throws JSONException {
        JSONArray jsonResults = new JSONArray();
        int scenarioIndex = -1;
        for (int i = 0; i < model.getScenarioList().getScenarios().size(); ++i) {
            if (!model.getScenarioAtIndex(i).equals(scenario)) continue;
            scenarioIndex = i;
            break;
        }
        if (scenarioIndex < 0) {
            throw new AgenaRiskRuntimeException("Scenario `" + scenario.getName().getShortDescription() + "` not found in model");
        }
        for (ExtendedBN ebn : model.getExtendedBNList().getExtendedBNs()) {
            for (ExtendedNode en : ebn.getExtendedNodes()) {
                DataSet ds;
                MarginalDataItem mdi;
                JSONObject jsonResult = new JSONObject();
                if (model.getMarginalDataStore().getMarginalDataItemListForNode(ebn, en).getMarginalDataItems().size() <= scenarioIndex) continue;
                jsonResult.put(CalculationResult.Field.network.toString(), (Object)ebn.getConnID());
                jsonResult.put(CalculationResult.Field.node.toString(), (Object)en.getConnNodeId());
                try {
                    mdi = model.getMarginalDataStore().getMarginalDataItemListForNode(ebn, en).getMarginalDataItemAtIndex(scenarioIndex);
                    ds = mdi.getDataset();
                }
                catch (NullPointerException ex) {
                    Logger.logIfDebug((String)("No MDI or DataSet for `" + ebn.getConnID() + "`.`" + en.getConnNodeId() + "` during API1 to API2 conversion"));
                    continue;
                }
                if (en instanceof NumericalEN) {
                    try {
                        JSONObject jsonSS = new JSONObject();
                        jsonSS.put(SummaryStatistic.Field.confidenceInterval.toString(), mdi.getConfidenceInterval());
                        jsonSS.put(SummaryStatistic.Field.mean.toString(), mdi.getMeanValue());
                        jsonSS.put(SummaryStatistic.Field.median.toString(), mdi.getMedianValue());
                        jsonSS.put(SummaryStatistic.Field.standardDeviation.toString(), mdi.getStandardDeviationValue());
                        jsonSS.put(SummaryStatistic.Field.variance.toString(), mdi.getVarianceValue());
                        jsonSS.put(SummaryStatistic.Field.entropy.toString(), mdi.getEntropyValue());
                        jsonSS.put(SummaryStatistic.Field.percentile.toString(), mdi.getPercentileValue());
                        jsonSS.put(SummaryStatistic.Field.lowerPercentile.toString(), mdi.getLowerPercentile());
                        jsonSS.put(SummaryStatistic.Field.upperPercentile.toString(), mdi.getUpperPercentile());
                        jsonResult.put(SummaryStatistic.Field.summaryStatistics.toString(), (Object)jsonSS);
                    }
                    catch (JSONException ex) {
                        if (ex.getMessage().contains("JSON does not allow non-finite numbers")) {
                            throw new AgenaRiskRuntimeException("Result data is corrupt, please recalculate the model", ex);
                        }
                        throw ex;
                    }
                }
                JSONArray jsonResultValues = new JSONArray();
                for (DataPoint dp : ds.getDataPoints()) {
                    JSONObject jsonResultValue = new JSONObject();
                    String label = dp.getLabel();
                    if (dp.getConnObjectId() >= 0) {
                        try {
                            ExtendedState es = en.getExtendedState(dp.getConnObjectId());
                            label = State.computeLabel(en, es);
                        }
                        catch (ExtendedStateNotFoundException es) {
                            // empty catch block
                        }
                    }
                    if (dp instanceof IntervalDataPoint && !(en instanceof RankedEN)) {
                        IntervalDataPoint idp = (IntervalDataPoint)dp;
                        label = idp.getIntervalLowerBound() + " - " + idp.getIntervalUpperBound();
                    }
                    jsonResultValue.put(ResultValue.Field.label.toString(), (Object)label);
                    jsonResultValue.put(ResultValue.Field.value.toString(), dp.getValue());
                    jsonResultValues.put((Object)jsonResultValue);
                }
                jsonResult.put(ResultValue.Field.resultValues.toString(), (Object)jsonResultValues);
                jsonResults.put((Object)jsonResult);
            }
        }
        return jsonResults;
    }

    private static JSONObject observationToJSON(Model model, Observation observation) throws ExtendedBNNotFoundException, ExtendedNodeNotFoundException, JSONException, ExtendedStateNotFoundException {
        JSONObject jsonObservation = new JSONObject();
        ExtendedBN ebn = model.getExtendedBN(observation.getConnExtendedBNId());
        jsonObservation.put(Observation.Field.network.toString(), (Object)ebn.getConnID());
        ExtendedNode en = ebn.getExtendedNode(observation.getConnExtendedNodeId());
        jsonObservation.put(Observation.Field.node.toString(), (Object)en.getConnNodeId());
        if (!observation.getExpressionVariableName().isEmpty()) {
            jsonObservation.put(Observation.Field.constantName.toString(), (Object)observation.getExpressionVariableName());
        }
        JSONArray jsonEntries = new JSONArray();
        if (en instanceof RankedEN || en instanceof LabelledEN || en instanceof DiscreteRealEN) {
            DataSet ds = observation.getDataSet();
            for (DataPoint dp : ds.getDataPoints()) {
                JSONObject jsonEntry = new JSONObject();
                String value = observation.getUserEnteredAnswer();
                ExtendedState es = null;
                try {
                    es = en.getExtendedState(dp.getConnObjectId());
                }
                catch (ExtendedStateNotFoundException extendedStateNotFoundException) {
                    // empty catch block
                }
                if (es != null) {
                    value = es.getName().getShortDescription();
                }
                jsonEntry.put(Observation.Field.value.toString(), (Object)value);
                jsonEntry.put(Observation.Field.weight.toString(), dp.getValue());
                jsonEntries.put((Object)jsonEntry);
            }
        } else {
            JSONObject jsonEntry = new JSONObject();
            String observationAnswer = observation.getUserEnteredAnswer();
            jsonEntry.put(Observation.Field.value.toString(), (Object)observationAnswer);
            jsonEntry.put(Observation.Field.weight.toString(), 1);
            jsonEntries.put((Object)jsonEntry);
        }
        jsonObservation.put(Observation.Field.entries.toString(), (Object)jsonEntries);
        return jsonObservation;
    }

    protected static JSONArray modelLinksToJSON(Model model) throws JSONException {
        JSONArray jsonLinks = new JSONArray();
        for (MessagePassingLinks mpls : model.getMessagePassingLinks()) {
            for (MessagePassingLink mpl : mpls.getLinks()) {
                try {
                    JSONObject jsonLink = JSONAdapter.cnLinkToJSON(model, mpl);
                    jsonLinks.put((Object)jsonLink);
                }
                catch (JSONException | ExtendedBNNotFoundException | ExtendedNodeNotFoundException | ExtendedStateNotFoundException ex) {
                    Logger.printThrowableIfDebug((Throwable)ex);
                }
            }
        }
        return jsonLinks;
    }

    private static JSONObject cnLinkToJSON(Model model, MessagePassingLink mpl) throws ExtendedBNNotFoundException, ExtendedNodeNotFoundException, ExtendedStateNotFoundException, JSONException {
        CrossNetworkLink.Type linkType;
        JSONObject jsonLink = new JSONObject();
        ExtendedBN ebn1 = model.getExtendedBN(mpl.getParentExtendedBNId());
        ExtendedNode en1 = ebn1.getExtendedNode(mpl.getParentExtendedNodeId());
        ExtendedBN ebn2 = model.getExtendedBN(mpl.getChildExtendedBNId());
        ExtendedNode en2 = ebn2.getExtendedNode(mpl.getChildExtendedNodeId());
        jsonLink.put(CrossNetworkLink.Field.sourceNetwork.toString(), (Object)ebn1.getConnID());
        jsonLink.put(CrossNetworkLink.Field.sourceNode.toString(), (Object)en1.getConnNodeId());
        jsonLink.put(CrossNetworkLink.Field.targetNetwork.toString(), (Object)ebn2.getConnID());
        jsonLink.put(CrossNetworkLink.Field.targetNode.toString(), (Object)en2.getConnNodeId());
        if (mpl instanceof ConstantSummaryMessagePassingLink) {
            ConstantSummaryMessagePassingLink csmpl = (ConstantSummaryMessagePassingLink)mpl;
            switch (csmpl.getSummaryStatistic()) {
                case MEAN: {
                    linkType = CrossNetworkLink.Type.Mean;
                    break;
                }
                case MEDIAN: {
                    linkType = CrossNetworkLink.Type.Median;
                    break;
                }
                case VARIANCE: {
                    linkType = CrossNetworkLink.Type.Variance;
                    break;
                }
                case STANDARD_DEVIATION: {
                    linkType = CrossNetworkLink.Type.StandardDeviation;
                    break;
                }
                case LOWER_PERCENTILE: {
                    linkType = CrossNetworkLink.Type.LowerPercentile;
                    break;
                }
                case UPPER_PERCENTILE: {
                    linkType = CrossNetworkLink.Type.UpperPercentile;
                    break;
                }
                default: {
                    throw new AgenaRiskRuntimeException("Invalid link summary statistic: " + csmpl.getSummaryStatistic().name());
                }
            }
        } else if (mpl instanceof ConstantStateMessagePassingLink) {
            linkType = CrossNetworkLink.Type.State;
            ConstantStateMessagePassingLink csmpl = (ConstantStateMessagePassingLink)mpl;
            ExtendedState es = en1.getExtendedState(csmpl.getParentNodeStateId());
            jsonLink.put(CrossNetworkLink.Field.passState.toString(), (Object)State.computeLabel(en1, es));
        } else {
            linkType = CrossNetworkLink.Type.Marginals;
        }
        jsonLink.put(CrossNetworkLink.Field.type.toString(), (Object)linkType.toString());
        return jsonLink;
    }

    protected static JSONObject modelMetaToJSON(Model model) throws JSONException {
        JSONObject jsonMeta = new JSONObject();
        JSONArray jsonNotes = new JSONArray();
        for (Note note : model.getNotes().getNotes()) {
            JSONObject jsonNote = new JSONObject();
            jsonNote.put(Meta.Field.name.toString(), (Object)note.getNd().getShortDescription());
            jsonNote.put(Meta.Field.text.toString(), (Object)note.getNd().getLongDescription());
            jsonNotes.put((Object)jsonNote);
        }
        jsonMeta.put(Meta.Field.notes.toString(), (Object)jsonNotes);
        return jsonMeta;
    }

    protected static JSONArray modelNetworksToJSON(Model model) throws JSONException {
        JSONArray jsonNetworks = new JSONArray();
        for (ExtendedBN ebn : model.getExtendedBNList().getExtendedBNs()) {
            try {
                jsonNetworks.put((Object)JSONAdapter.toJSONObject(ebn));
            }
            catch (ExtendedBNException ex) {
                throw new AgenaRiskRuntimeException("Failed to encode a Model to JSON", ex);
            }
        }
        return jsonNetworks;
    }

    public static JSONObject toJSONObject(ExtendedBN ebn) throws JSONException, ExtendedBNException {
        JSONObject jsonNetwork = new JSONObject();
        jsonNetwork.put(Network.Field.id.toString(), (Object)ebn.getConnID());
        jsonNetwork.put(Network.Field.name.toString(), (Object)ebn.getName().getShortDescription());
        if (ebn.getName().getLongDescription().trim().length() > 0) {
            jsonNetwork.put(Network.Field.description.toString(), (Object)ebn.getName().getLongDescription());
        }
        JSONArray jsonNodes = new JSONArray();
        for (Object en : ebn.getExtendedNodes()) {
            jsonNodes.put((Object)JSONAdapter.toJSONObject((ExtendedNode)en));
        }
        jsonNetwork.put(Node.Field.nodes.toString(), (Object)jsonNodes);
        JSONArray jsonLinks = new JSONArray();
        for (ExtendedNode en : ebn.getExtendedNodes()) {
            for (ExtendedNode enParent : ebn.getParentNodes(en)) {
                JSONObject jsonLink = new JSONObject();
                jsonLink.put(Link.Field.parent.toString(), (Object)enParent.getConnNodeId());
                jsonLink.put(Link.Field.child.toString(), (Object)en.getConnNodeId());
                jsonLinks.put((Object)jsonLink);
            }
        }
        jsonNetwork.put(Link.Field.links.toString(), (Object)jsonLinks);
        if (ebn.getModificationLog() != null && ebn.getModificationLog().getModificationItems() != null) {
            JSONArray modificationLog = new JSONArray();
            for (ModificationLog.ModificationLogItem mli : ebn.getModificationLog().getModificationItems()) {
                JSONObject entry = new JSONObject();
                entry.put(Network.ModificationLog.action.toString(), (Object)mli.getDescription().getShortDescription());
                entry.put(Network.ModificationLog.description.toString(), (Object)mli.getDescription().getLongDescription());
                modificationLog.put((Object)entry);
            }
            jsonNetwork.put(Network.ModificationLog.modificationLog.toString(), (Object)modificationLog);
        }
        return jsonNetwork;
    }

    protected static JSONArray modelRiskTableToJSON(Model model) throws JSONException, AdapterException {
        JSONArray jsonRiskTable = new JSONArray();
        for (Questionnaire qstr : model.getQuestionnaireList().getQuestionnaires()) {
            JSONObject jsonQstr = new JSONObject();
            jsonQstr.put(RiskTable.Questionnaire.name.toString(), (Object)qstr.getName().getShortDescription());
            jsonQstr.put(RiskTable.Questionnaire.description.toString(), (Object)qstr.getName().getLongDescription());
            JSONArray jsonQstns = new JSONArray();
            for (Question qstn : qstr.getQuestions()) {
                JSONObject jsonQstn = new JSONObject();
                jsonQstn.put(RiskTable.Question.name.toString(), (Object)qstn.getName().getShortDescription());
                jsonQstn.put(RiskTable.Question.description.toString(), (Object)qstn.getName().getLongDescription());
                ExtendedBN ebn = null;
                ExtendedNode en = null;
                try {
                    ebn = model.getExtendedBN(qstn.getConnExtendedBNId());
                    en = ebn.getExtendedNode(qstn.getConnExtendedNodeId());
                }
                catch (ExtendedBNNotFoundException | ExtendedNodeNotFoundException ex) {
                    throw new AdapterException("Questionnaire Network or node not found", ex);
                }
                jsonQstn.put(RiskTable.Question.network.toString(), (Object)ebn.getConnID());
                jsonQstn.put(RiskTable.Question.node.toString(), (Object)en.getConnNodeId());
                String questionMode = "";
                String questionType = RiskTable.QuestionType.observation.toString();
                switch (qstn.getRecommendedAnsweringMode()) {
                    case 1: {
                        questionMode = RiskTable.QuestionMode.selection.toString();
                        break;
                    }
                    case 2: {
                        questionMode = RiskTable.QuestionMode.unanswerable.toString();
                        break;
                    }
                    case 0: {
                        questionMode = RiskTable.QuestionMode.numerical.toString();
                        break;
                    }
                    case 3: {
                        questionMode = RiskTable.QuestionMode.numerical.toString();
                        questionType = RiskTable.QuestionType.constant.toString();
                        break;
                    }
                    default: {
                        throw new AdapterException("Invalid questionnaire mode: " + qstn.getRecommendedAnsweringMode());
                    }
                }
                if (qstn.getRecommendedAnsweringMode() == 3) {
                    jsonQstn.put(RiskTable.Question.constantName.toString(), (Object)qstn.getExpressionVariableName());
                }
                jsonQstn.put(RiskTable.Question.mode.toString(), (Object)questionMode);
                jsonQstn.put(RiskTable.Question.type.toString(), (Object)questionType);
                jsonQstn.put(RiskTable.Question.visible.toString(), qstn.getVisible());
                jsonQstn.put(RiskTable.Question.syncName.toString(), qstn.isSyncToConnectedNodeName());
                JSONArray jsonAnsws = new JSONArray();
                for (Answer answ : qstn.getAnswers()) {
                    try {
                        int stateId = answ.getConnExtendedStateId();
                        ExtendedState extendedState = en.getExtendedState(stateId);
                    }
                    catch (ExtendedStateNotFoundException ex) {
                        Logger.logIfDebug((String)("Resetting answers to state mapping " + en.getConnNodeId() + " [" + en.getName().getShortDescription() + "]"), (PrintStream)Logger.err());
                        Logger.logIfDebug((String)("Broken answer was: " + answ.getName() + " [" + answ.getConnExtendedStateId() + "]"), (PrintStream)Logger.err());
                        Question tempQstn = Model.generateQuestionFromNode((ExtendedBN)ebn, (ExtendedNode)en);
                        qstn.setAnswers(tempQstn.getAnswers());
                        break;
                    }
                }
                for (Answer answ : qstn.getAnswers()) {
                    JSONObject jsonAnsw = new JSONObject();
                    jsonAnsw.put(RiskTable.Answer.name.toString(), (Object)answ.getName().getShortDescription());
                    try {
                        int stateId = answ.getConnExtendedStateId();
                        ExtendedState correspondingState = en.getExtendedState(stateId);
                        jsonAnsw.put(RiskTable.Answer.state.toString(), (Object)State.computeLabel(en, correspondingState).trim());
                    }
                    catch (ExtendedStateNotFoundException ex) {
                        throw new AdapterException("Questionnaire answer state not found in node " + en.getConnNodeId() + "[" + en.getName().getShortDescription() + "]", ex);
                    }
                    jsonAnsws.put((Object)jsonAnsw);
                }
                jsonQstn.put(RiskTable.Answer.answers.toString(), (Object)jsonAnsws);
                jsonQstns.put((Object)jsonQstn);
            }
            jsonQstr.put(RiskTable.Question.questions.toString(), (Object)jsonQstns);
            jsonRiskTable.put((Object)jsonQstr);
        }
        return jsonRiskTable;
    }

    public static JSONObject toJSONObject(ExtendedNode en) throws JSONException {
        JSONObject jsonGraphics;
        JSONObject json = new JSONObject();
        json.put(Node.Field.id.toString(), (Object)en.getConnNodeId());
        json.put(Node.Field.name.toString(), (Object)en.getName().getShortDescription());
        if (en.getName().getLongDescription().trim().length() > 0) {
            json.put(Node.Field.description.toString(), (Object)en.getName().getLongDescription());
        }
        JSONObject jsonConfiguration = JSONAdapter.nodeConfigToJSON(en);
        json.put(NodeConfiguration.Field.configuration.toString(), (Object)jsonConfiguration);
        if (!en.getNotes().getNotes().isEmpty()) {
            json.put(Meta.Field.meta.toString(), (Object)JSONAdapter.nodeMetaToJSON(en));
        }
        if (!(jsonGraphics = JSONAdapter.nodeGraphicsToJSON(en)).isEmpty()) {
            json.put(NodeGraphics.Field.graphics.toString(), (Object)jsonGraphics);
        }
        return json;
    }

    protected static JSONObject nodeConfigToJSON(ExtendedNode en) throws JSONException {
        JSONObject jsonConfig = new JSONObject();
        Node.Type nodeType = NodeConfiguration.resolveNodeType(en);
        jsonConfig.put(NodeConfiguration.Field.type.toString(), (Object)nodeType.toString());
        if (en.isConnectableInputNode()) {
            jsonConfig.put(NodeConfiguration.Field.input.toString(), en.isConnectableInputNode());
        }
        if (en.isConnectableOutputNode()) {
            jsonConfig.put(NodeConfiguration.Field.output.toString(), en.isConnectableOutputNode());
        }
        boolean simulated = false;
        if (en instanceof ContinuousEN && !(en instanceof RankedEN)) {
            ContinuousEN cen = (ContinuousEN)en;
            simulated = cen.isSimulationNode();
            jsonConfig.putOpt(NodeConfiguration.Field.simulated.toString(), (Object)(simulated ? Boolean.valueOf(true) : null));
            if (simulated && cen.getEntropyConvergenceThreshold() >= 0.0) {
                jsonConfig.put(NodeConfiguration.Field.simulationConvergence.toString(), cen.getEntropyConvergenceThreshold());
            }
        }
        JSONObject jsonTable = JSONAdapter.nodeTableToJSON(en);
        jsonConfig.put(NodeConfiguration.Table.table.toString(), (Object)jsonTable);
        if (!simulated) {
            JSONArray jsonStates = new JSONArray();
            for (ExtendedState es : en.getExtendedStates()) {
                jsonStates.put((Object)State.computeLabel(en, es).trim());
            }
            jsonConfig.put(State.Field.states.toString(), (Object)jsonStates);
        }
        if (!en.getExpressionVariables().getVariables().isEmpty()) {
            JSONArray jsonVariables = new JSONArray();
            for (Variable variable : en.getExpressionVariables().getVariables()) {
                if (!variable.isEditable()) continue;
                JSONObject jsonVariable = new JSONObject();
                jsonVariable.put(NodeConfiguration.Variables.name.toString(), (Object)variable.getName());
                jsonVariable.put(NodeConfiguration.Variables.value.toString(), variable.getDefaultValue());
                jsonVariables.put((Object)jsonVariable);
            }
            jsonConfig.put(NodeConfiguration.Variables.variables.toString(), (Object)jsonVariables);
        }
        return jsonConfig;
    }

    protected static JSONObject nodeGraphicsToJSON(ExtendedNode en) throws JSONException {
        JSONObject jsonGraphics = new JSONObject();
        if (!en.getVisible()) {
            jsonGraphics.put(NodeGraphics.Field.visible.toString(), en.getVisible());
        }
        return jsonGraphics;
    }

    public static JSONObject nodeTableToJSON(ExtendedNode en) throws JSONException {
        NodeConfiguration.TableType tableType;
        JSONObject jsonTable = new JSONObject();
        switch (en.getFunctionMode()) {
            case 0: {
                tableType = NodeConfiguration.TableType.Manual;
                break;
            }
            case 1: {
                tableType = NodeConfiguration.TableType.Expression;
                break;
            }
            case 2: {
                tableType = NodeConfiguration.TableType.Partitioned;
                break;
            }
            default: {
                throw new AgenaRiskRuntimeException("Invalid node table type `" + en.getFunctionMode() + "` for node `" + en.getConnNodeId() + "`");
            }
        }
        jsonTable.put(NodeConfiguration.Table.type.toString(), (Object)tableType.toString());
        if (tableType.equals((Object)NodeConfiguration.TableType.Partitioned)) {
            JSONArray jsonPartitions = new JSONArray();
            for (Object partitionParent : en.getPartitionedExpressionModelNodes()) {
                jsonPartitions.put((Object)partitionParent.getConnNodeId());
            }
            jsonTable.put(NodeConfiguration.Table.partitions.toString(), (Object)jsonPartitions);
        }
        JSONArray jsonExpressions = new JSONArray();
        ArrayList<ExtendedNodeFunction> enfs = new ArrayList<ExtendedNodeFunction>();
        if (tableType.equals((Object)NodeConfiguration.TableType.Expression)) {
            enfs.add(en.getCurrentNodeFunction());
        } else if (tableType.equals((Object)NodeConfiguration.TableType.Partitioned)) {
            enfs.addAll(en.getCurrentPartitionedModelNodeFunctions());
        }
        for (ExtendedNodeFunction enf : enfs) {
            String expressionString = "";
            try {
                expressionString = enf.getName().replaceAll(" ", "");
            }
            catch (NullPointerException ex) {
                throw new AgenaRiskRuntimeException("Node `" + en.getName().getShortDescription() + " (" + en.getConnNodeId() + ")` is expected to have expressions, but has none", ex);
            }
            expressionString = expressionString + "(" + enf.getParameters().stream().collect(Collectors.joining(",")) + ")";
            jsonExpressions.put((Object)expressionString);
        }
        if (!enfs.isEmpty()) {
            jsonTable.put(NodeConfiguration.Table.expressions.toString(), (Object)jsonExpressions);
        }
        boolean simulated = en instanceof ContinuousEN && ((ContinuousEN)en).isSimulationNode();
        boolean manual = tableType.equals((Object)NodeConfiguration.TableType.Manual);
        if (!simulated) {
            float[][] npt;
            if (!manual) {
                // empty if block
            }
            try {
                npt = en.getNPT();
            }
            catch (ExtendedBNException ex) {
                throw new AgenaRiskRuntimeException("Failed to retrieve NPT for node `" + en.getConnNodeId() + "`", ex);
            }
            JSONArray jsonRows = new JSONArray();
            for (float[] row : npt) {
                JSONArray jsonRow = new JSONArray();
                for (float p : row) {
                    jsonRow.put(p);
                }
                jsonRows.put((Object)jsonRow);
            }
            jsonTable.put(NodeConfiguration.Table.probabilities.toString(), (Object)jsonRows);
        }
        jsonTable.put(NodeConfiguration.Table.nptCompiled.toString(), !en.isNptReCalcRequired());
        return jsonTable;
    }

    protected static JSONObject nodeMetaToJSON(ExtendedNode en) throws JSONException {
        JSONObject jsonMeta = new JSONObject();
        JSONArray jsonNotes = new JSONArray();
        for (Note note : en.getNotes().getNotes()) {
            JSONObject jsonNote = new JSONObject();
            jsonNote.put(Meta.Field.name.toString(), (Object)note.getNd().getShortDescription());
            jsonNote.put(Meta.Field.text.toString(), (Object)note.getNd().getLongDescription());
            jsonNotes.put((Object)jsonNote);
        }
        jsonMeta.put(Meta.Field.notes.toString(), (Object)jsonNotes);
        return jsonMeta;
    }
}

